<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\Cms\Controller\Index;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Controller\Result\JsonFactory;

class GetPage extends \Magento\Framework\App\Action\Action
{
    protected $resultJsonFactory;
    /**
     * @param \Magento\Framework\App\Action\Context $context
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        JsonFactory $resultJsonFactory
    ) {
        $this->resultJsonFactory    = $resultJsonFactory;
        parent::__construct($context);
    }
    public function execute()
    {
        $identifier = $this->getRequest()->getParam('identifier');
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $CmsPage = $objectManager->get(\Magento\Cms\Model\Page::class);
        $CmsPage->load($identifier, 'identifier');
        $data = [];
        $data['title'] = $CmsPage->getTitle();
        $data['content'] = $CmsPage->getContent();
        $resultPage = $this->resultJsonFactory->create();
        $resultPage->setHttpResponseCode(200);
        $resultPage->setData($data);
        return $resultPage;
    }
}
