define([
        'jquery',
        'ko',
        'uiComponent',
        'uiRegistry',
        'Magento_Checkout/js/model/checkout-data-resolver',
        'Magento_Checkout/js/model/quote'
    ], function ($, ko, Component,registry,checkoutDataResolver,quote) {
        'use strict';
        var input_city = $('#co-shipping-form input[name="city"]');

        if (input_city.is(':visible') && !input_city.closest('.field').hasClass('_required')) {
            input_city.attr('required',true);
            input_city.attr('_required',true);
        }
        var addressOneVisible = ko.observable(true),
            shippingTwoVisible = ko.observable(false),
            paymentThreeVisible = ko.observable(false);
        return Component.extend({


            addressOneVisible: addressOneVisible,
            shippingTwoVisible: shippingTwoVisible,
            paymentThreeVisible: paymentThreeVisible,
            initialize: function () {
                this.initStep(this);
                this._super();
                return this;
            },
            initStep: function (obj) {
                $(document).on('click','.continue-shipping',function(){
                    if(shippingTwoVisible() || paymentThreeVisible())
                    {
                        obj.backToInformation();
                        return false;
                    }
                    var loginForm = $('.form.form-login');
                    var addressForm = $('#checkout-step-shipping>#co-shipping-form');

                    if (loginForm.length > 0 && !loginForm.validate().form()) {
                        return false;
                    }
                    var shippingString = '';
                    var email = '';
                    if (addressForm.length > 0) {
                        if (!$('#co-shipping-form input[name="region"]').closest('.field').hasClass('_required')) {
                            $('#co-shipping-form input[name="region"]').removeAttr('required');
                        }
                        if (!$('#co-shipping-form input[name="street[1]"]').closest('.field').hasClass('_required')) {
                            $('#co-shipping-form input[name="street[1]"]').removeAttr('required');
                        }
                        if (!$('#co-shipping-form input[name="company"]').closest('.field').hasClass('_required')) {
                            $('#co-shipping-form input[name="company"]').removeAttr('required');
                        }
                        var region_select = $('#co-shipping-form select[name="region_id"]');
                        if (region_select.is(':visible') && region_select.closest('.field').hasClass('_required')) {
                            region_select.attr('required',true);
                        }
                        var selectInput = $('#shipping-new-address-form .select-input');
                        if(selectInput.length > 0){
                            for(var i=0;i<selectInput.length;i++){
                                var selectName = $(selectInput[i]).next('select').attr('name');
                                $(selectInput[i]).attr('name',selectName)
                            }
                        }
                        if (!addressForm.validate().form()) {
                            if(selectInput.length > 0){
                                for(var i=0;i<selectInput.length;i++){
                                    $(selectInput[i]).removeAttr('name')
                                }
                            }
                            if ($(window).width() < 768) {
                                var scrollTop = $('#opc-shipping_method').offset().top - 100;
                                $('html,body').animate({scrollTop: scrollTop}, 'fast');
                            }
                            return false;
                        }

                        if(selectInput.length > 0){
                            for(var i=0;i<selectInput.length;i++){
                                $(selectInput[i]).removeAttr('name')
                            }
                        }
                        email = $('#customer-emails').val() || '';
                        var firstname = $('#co-shipping-form input[name="firstname"]').val();
                        var lastname = $('#co-shipping-form input[name="lastname"]').val();
                        var street = $('#co-shipping-form input[name="street[0]"]').val();
                        var city = $('#co-shipping-form input[name="city"]').val();
                        var postcode = $('#co-shipping-form input[name="postcode"]').val();
                        var telephone = $('#co-shipping-form input[name="telephone"]').val();
                        var country = $('#co-shipping-form select[name="country_id"]').find(":selected").text();
                        var regin;
                        if ($('#co-shipping-form input[name="region"]').is(':visible')) {
                            regin = $('#co-shipping-form input[name="region"]').val();
                        } else {
                            regin = region_select.find(":selected").text();
                        }
                        shippingString = firstname + ' ' + lastname + ',' + street + ',' + city + ', ' + regin + ', ' + country + ',' + postcode + ', ' + telephone;
                    }
                    $('.address-one').hide();
                    $('.shipping-two').show();
                    $('#email-text').show();
                    $('#email-text .main-text').html(email);
                    $('#shipping-text').show();
                    $('.payment-content').show();
                    $('#shipping-text .main-text').html(shippingString);
                    $('#breadcrumb-fill-info').addClass('custom-link-color');
                    $('#breadcrumb-logistics').removeClass('trade_checkout_step_waiting');
                    addressOneVisible(false);
                    shippingTwoVisible(true);
                    //quote.billAddressMent(true);
                    checkoutDataResolver.resolveEstimationAddress();
                });

                $(document).on('click','.continue-payment',function() {

                    if(addressOneVisible() || !shippingTwoVisible())
                    {
                        obj.backToInformation();
                        return false;
                    }
                    var paymentMethodObj = $('.checkout-index-index .payment-method');
                    if(paymentMethodObj.length < 1)
                    {
                        return false;
                    }

                    var inputChecked = $('#checkout-shipping-method-load').find('input:radio:checked');
                    var shippingPrice = $(inputChecked).siblings('.col-amount').html();
                    var shipString = $(inputChecked).siblings('.col-carrier').html() +
                        '  ' + '<span class="price">' + shippingPrice + '</span>';

                    $('#breadcrumb-logistics').addClass('custom-link-color');
                    $('#breadcrumb-payment').removeClass('trade_checkout_step_waiting');



                    $(paymentMethodObj[0]).find('input[type="radio"]').trigger('click');
                    $('#shipping-text .trade_info-preview-item').addClass('mian-text-line');
                    $('.shipping-two').hide();
                    $('.payment-three').show();
                    $('#method-text .main-text').html(shipString);
                    shippingTwoVisible(false);
                    paymentThreeVisible(true);
                });
                $(document).on('click','.complete-order',function() {
                    if(!paymentThreeVisible())
                    {
                        obj.backToInformation();
                        return false;
                    }
                    $('.waitBtn').show();
                    $('.complete-order').hide();
                    if(!registry.get('checkout.steps.shipping-step.shippingAddress.after-shipping-method-form.billing-address-form').isAddressSameAsShipping())
                    {
                        var billadressForm = $('.checkout-billing-address form');

                        if(billadressForm.length > 0)
                        {
                            if (!$('.checkout-billing-address input[name="region"]').closest('.field').hasClass('_required')) {
                                $('.checkout-billing-address input[name="region"]').removeAttr('required');
                            }
                            if (!$('.checkout-billing-address input[name="street[1]"]').closest('.field').hasClass('_required')) {
                                $('.checkout-billing-address input[name="street[1]"]').removeAttr('required');
                            }
                            if (!$('.checkout-billing-address input[name="company"]').closest('.field').hasClass('_required')) {
                                $('.checkout-billing-address input[name="company"]').removeAttr('required');
                            }
                            var region_select = $('.checkout-billing-address select[name="region_id"]');
                            if (region_select.is(':visible') && region_select.closest('.field').hasClass('_required')) {
                                region_select.attr('required',true);
                            }

                            var selectInput = $('.checkout-billing-address .select-input');
                            if(selectInput.length > 0){
                                for(var i=0;i<selectInput.length;i++){
                                    var selectName = $(selectInput[i]).next('select').attr('name');
                                    $(selectInput[i]).attr('name',selectName)
                                }
                            }
                            if (!billadressForm.validate().form()) {
                                if(selectInput.length > 0){
                                    for(var i=0;i<selectInput.length;i++){
                                        $(selectInput[i]).removeAttr('name')
                                    }
                                }
                                $('.waitBtn').hide();
                                $('.complete-order').show();
                                return false;
                            }

                            if(selectInput.length > 0){
                                for(var i=0;i<selectInput.length;i++){
                                    $(selectInput[i]).removeAttr('name')
                                }
                            }
                        }else {
                            $('.waitBtn').hide();
                            $('.complete-order').show();
                            return false;
                        }

                        $('#submitBill').trigger('click');
                        if(quote.responseBillStatus() == 400)
                        {
                            $('.waitBtn').hide();
                            $('.complete-order').show();
                            return false;
                        }
                    }

                    $('.checkout-index-index .payment-method._active').find('.actions-toolbar').find('button').trigger('click');
                });
                $(document).on('click','.back-to-information,.trade_checkout_step_doing.custom-link-color,.right-email,.right-address',function() {
                    obj.backToInformation();
                });
                $(document).on('click','.back-to-shipping,.shipping-btn.custom-link-color,.right-method',function() {
                    if(shippingTwoVisible() || !paymentThreeVisible())
                    {
                        obj.backToInformation();
                        return false;
                    }
                    $('.shipping-two').show();
                    $('.payment-three').hide();
                    $('#method-text .main-text').html('');
                    $('#method-text').hide();
                    this.shippingTwoVisible(true);
                    this.paymentThreeVisible(false);
                });
                $(document).on('click','.mobile-control',function() {
                    var flag = $(this).parent().attr('aria-expanded');
                    if(flag == 'true') {
                        $('.opc-block-summary').show();
                        $('.items-in-cart').removeClass('bottom-border');
                    } else {
                        $('.opc-block-summary').hide();
                        $('.items-in-cart').addClass('bottom-border');
                    }

                });
            },
            backToInformation: function(){
                $('.address-one').show();
                $('.shipping-two').hide();
                $('.payment-three').hide();
                $('.checkout-top-page .main-text').html('');
                $('.checkout-top-page').hide();
                $('.payment-content').hide();
                paymentThreeVisible(true);
                shippingTwoVisible(false);
                paymentThreeVisible(false);
            }
        });
    }
);
