<?php
namespace Joshine\InstagramFeed\Block;


use Joshine\InstagramFeed\Model\Cache\Type;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Template;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Cache;
use phpDocumentor\Reflection\PseudoTypes\LiteralString;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Serialize\Serializer\Json;

class MediaFeed extends Template {

    const TYPE_IDENTIFIER = 'instagram_feed';

    const CACHE_TAG       = 'INSTAGRAM_FEED';

    const CACHE_LIFETIME  = 60 * 60 * 24;

    protected $request;

    protected $_template = 'Joshine_InstagramFeed::mediafeed.phtml';
    /**
     * @var \Magento\Framework\ObjectManagerInterface
     */
    private $_objectManager;
    /**
     * @var ApiAddress
     */
    private $apiAddress;
    private $_curlClient;
    /**
     * @var \Magento\Framework\Json\EncoderInterface
     */
    private $jsonEncoder;
    /**
     * @var \Magento\Framework\Json\Decoder
     */
    private $jsonDecoder;
    /**
     * @var string
     */
    private $id;

    private $_json;

    public function __construct(
        Template\Context $context,
        \Magento\Framework\ObjectManagerInterface $objectManager,
        \Magento\Framework\App\Request\Http $request,
        ApiAddress $apiAddress,
        \Magento\Framework\HTTP\Client\Curl $curl,
        \Magento\Framework\Json\EncoderInterface $jsonEncoder,
        \Magento\Framework\Json\Decoder $jsonDecoder,
        Json $json,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->request = $request;
        $this->id = $this->getId();
        $this->_objectManager = $objectManager;
        $this->apiAddress     = $apiAddress;
        $this->_curlClient    = $curl;
        $this->jsonEncoder    = $jsonEncoder;
        $this->jsonDecoder    = $jsonDecoder;
        $this->_json = $json;
    }

    public function getCurlClient()
    {
        return $this->_curlClient;
    }

    public function getMediaByCache()
    {
        if ($this->_cacheState->isEnabled(Type::TYPE_IDENTIFIER)) {
            if ($feed = $this->_cache->load($this->id)) {
                return $this->_json->unserialize($feed);
            }
        }
        return [];
    }

    public function getMediaByApi()
    {
        $uid = $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_instagram_feed/general/user_id',
                ScopeInterface::SCOPE_STORE
            );

        $token = $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_instagram_feed/general/access_token',
                ScopeInterface::SCOPE_STORE
            );

        $url = $this->apiAddress->getMediaUrl($token, $uid);

        try {
            $this->getCurlClient()->get($url);
            $this->getCurlClient()
                ->setOptions([
                    CURLOPT_SSL_VERIFYHOST => false,
                    CURLOPT_SSL_VERIFYPEER => false
                ]);
            if ($this->getCurlClient()->getStatus() != 200) {
                return [];
            }
        } catch (\Exception $e) {
            $this->_logger->error($e->getMessage());
            return [];
        }
        return $this->jsonDecoder->decode($this->getCurlClient()->getBody());
    }

    public function cacheFeed($feed)
    {
        if ($this->_cacheState->isEnabled(Type::TYPE_IDENTIFIER)) {
            $this->save($feed, $this->id);
        }
        return true;
    }

    public function getId()
    {
        try {
            return base64_encode($this->_storeManager->getStore()->getCode() . Type::TYPE_IDENTIFIER);
        } catch (NoSuchEntityException $e) {
            return base64_encode(date('Y-m-d') . Type::TYPE_IDENTIFIER);
        }
    }

    public function load($cacheId)
    {
        if ($this->_cacheState->isEnabled(Type::TYPE_IDENTIFIER)) {
            return $this->_cache->load($cacheId) ?: false;
        }

        return false;
    }

    public function save($data, $cacheId)
    {
        if ($this->_cacheState->isEnabled(Type::TYPE_IDENTIFIER)) {
            return $this->_cache->save($data, $cacheId, [Type::CACHE_TAG], Type::CACHE_LIFETIME);
        }

        return false;
    }

    public function getMedia() {
        $cache = $this->getMediaByCache();
        if (!empty($cache)) {
            return $this->encodePostContent($cache);
        }

        $feed = $this->getMediaByApi();
        if (isset($feed['data'])) {
            $this->cacheFeed($this->_json->serialize($feed));
        } else {
            return [];
        }
        return $this->encodePostContent($feed);
    }

    public function encodePostContent($feed)
    {
        foreach ($feed['data'] as $index => $row) {
            if (isset($row['caption'])) {
                $feed['data'][$index]["caption"] = base64_encode($row["caption"]);
            }
        }
        $feed['data'] = array_merge($feed['data'], []);
        return $feed;
    }

    public function isOpen()
    {
       return $this->_objectManager->get(ScopeConfigInterface::class)
            ->getValue(
                'joshine_instagram_feed/general/enabled',
                ScopeInterface::SCOPE_STORE
            );
    }

}