<?php
namespace Joshine\Review\Helper;

use Joshine\Review\Block\Images;
use Joshine\Review\Block\Review\ToolBar;

class BlockHelper implements \Magento\Framework\Data\CollectionDataSourceInterface
{

    /**
     * @var \Magento\Framework\View\Element\BlockFactory
     */
    private $blockFactory;


    /**
     * @var \Magento\Framework\Stdlib\StringUtils
     */
    private $stringUtils;

    /**
     * @var \Magento\Customer\Model\SessionFactory
     */
    private $sessionFactory;

    /**
     * @var \Magento\Framework\Escaper
     */
    private $escaper;

    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    public function __construct(
        \Magento\Framework\View\Element\BlockFactory $blockFactory,
        \Magento\Framework\Stdlib\StringUtils $stringUtils,
        \Magento\Customer\Model\SessionFactory $sessionFactory,
        \Magento\Framework\Escaper $escaper,
        \Magento\Framework\UrlInterface $urlBuilder,
        \Magento\Framework\App\RequestInterface $request
    ) {
        $this->blockFactory = $blockFactory;
        $this->stringUtils = $stringUtils;
        $this->sessionFactory = $sessionFactory;
        $this->escaper = $escaper;
        $this->urlBuilder = $urlBuilder;
        $this->request = $request;
    }
    public function getReviewImagesHtml($reviewId, $productId)
    {
        $html = '';
        $block = $this->blockFactory
            ->createBlock(Images::class)
            ->setProductId($productId)
            ->setReviewId($reviewId);
        if ($block) {
            $html = $block->toHtml();
        }
        return $html;
    }

    public function getToolBarHtML()
    {
        return $this->blockFactory
            ->createBlock(ToolBar::class)
            ->toHtml();
    }


    public function getReviewImagesBlock($reviewId, $productId) : Images
    {
        return $this->blockFactory
            ->createBlock(Images::class)
            ->setProductId($productId)
            ->setReviewId($reviewId);
    }

}
