<?php

namespace Joshine\Review\Block;

use Joshine\Review\Model\ResourceModel\Images\Collection;
use Joshine\Review\Helper\ImageHelper;
use Magento\Framework\View\Element\Template;
use Joshine\Review\Model\ResourceModel\Images\CollectionFactory;

/**
 * Class Images
 * @package Amasty\AdvancedReview\Block
 */
class Images extends \Magento\Framework\View\Element\Template
{
    //评论缩略图宽度
    const REVIEW_COVER_WIDTH = 200;

    /**
     * @var string
     */
    protected $_template = 'Joshine_Review::images.phtml';

    private $reviewId;

    private $productId;

    /**
     * @var int
     */

    /**
     * @var \Magento\Framework\Json\EncoderInterface
     */
    private $jsonEncoder;
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var ImageHelper
     */
    private $imageHelper;

    public function __construct(
        Template\Context $context,
        CollectionFactory $collectionFactory,
        \Magento\Framework\Json\EncoderInterface $jsonEncoder,
        ImageHelper $imageHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->jsonEncoder       = $jsonEncoder;
        $this->collectionFactory = $collectionFactory;
        $this->imageHelper       = $imageHelper;
    }

    /**
     * @return int
     */
    public function getReviewId(): int
    {
        return $this->reviewId;
    }

    /**
     * @param $reviewId
     *
     * @return $this
     */
    public function setReviewId($reviewId): Images
    {
        $this->reviewId = $reviewId;
        return $this;
    }

    public function setProductId($productId): Images
    {
        $this->productId = $productId;
        return $this;
    }

    public function getProductId()
    {
        return $this->productId;
    }

    public function getCollection() {
        /** @var Collection $collection */
        $collection = $this->collectionFactory->create()
            ->addFieldToSelect('*')
            ->addFieldToFilter('review_id', $this->getReviewId());

        return $collection;
    }


    public function getFullImagePath($item): string
    {
        return $this->imageHelper->getFullPath($item->getPath());
    }

    /**
     * @param $item
     * @return string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getResizedImagePath($item): string
    {
        return $this->imageHelper->resize($item->getPath(), self::REVIEW_COVER_WIDTH * 2);
    }

    /**
     * @param $item
     * @return string
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getResizedImagePathByLimit($item, $width): string
    {
        return $this->imageHelper->resize($item->getPath(), $width);
    }

}
