<?php

namespace Joshine\Review\Block\Components;

use Magento\Framework\Serialize\Serializer\Json;
use Magento\Framework\View\Element\Template;

class Pager extends \Magento\Theme\Block\Html\Pager
{

    const DEFAULT_PAGE_SIZE = 3;
    /**
     * @var string
     */
    protected $_template = 'Joshine_Review::components/pager.phtml';

    /**
     * @var Json
     */
    private $json;

    public function __construct(
        Template\Context $context,
        Json $json,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->json = $json;
    }

    /**
     * @return string
     */
    public function getJsonData()
    {
        return $this->json->serialize($this->getData());
    }
}
