define([
        'jquery',
        'uiComponent',
        'uiRegistry',
        'Magento_Checkout/js/model/checkout-data-resolver',
        'Magento_Checkout/js/model/quote'
    ], function ($, Component,registry,checkoutDataResolver,quote) {
        'use strict';
        var input_city = $('#co-shipping-form input[name="city"]');
        if (input_city.is(':visible') && !input_city.closest('.field').hasClass('_required')) {
            input_city.attr('required',true);
            input_city.attr('_required',true);
        }
        return Component.extend({
            initialize: function () {
                this.initStep();
                this._super();
                return this;
            },
            initStep: function () {
                $(document).on('click', '#next-shipping>span', function () {
                    var loginForm = $('.form.form-login');
                    var addressForm = $('#checkout-step-shipping>#co-shipping-form');
                    if (loginForm.length > 0 && !loginForm.validate().form()) {
                        return false;
                    }
                    if (addressForm.length > 0) {
                        if (!$('#co-shipping-form input[name="region"]').closest('.field').hasClass('_required')) {
                            $('#co-shipping-form input[name="region"]').removeAttr('required');
                        }
                        if (!$('#co-shipping-form input[name="street[1]"]').closest('.field').hasClass('_required')) {
                            $('#co-shipping-form input[name="street[1]"]').removeAttr('required');
                        }
                        if (!$('#co-shipping-form input[name="company"]').closest('.field').hasClass('_required')) {
                            $('#co-shipping-form input[name="company"]').removeAttr('required');
                        }
                        var region_select = $('#co-shipping-form select[name="region_id"]');
                        if (region_select.is(':visible') && region_select.closest('.field').hasClass('_required')) {
                            region_select.attr('required',true);
                        }
                        if (!addressForm.validate().form()) {
                            return false;
                        }



                        var paymentMethodObj = $('.checkout-index-index .payment-method');
                        if(paymentMethodObj.length < 1)
                        {
                            return false;
                        }
                        var email = $('#customer-email').val() || '';
                        var firstname = $('#co-shipping-form input[name="firstname"]').val();
                        var lastname = $('#co-shipping-form input[name="lastname"]').val();
                        var street = $('#co-shipping-form input[name="street[0]"]').val();
                        var city = $('#co-shipping-form input[name="city"]').val();
                        var postcode = $('#co-shipping-form input[name="postcode"]').val();
                        var telephone = $('#co-shipping-form input[name="telephone"]').val();
                        var country = $('#co-shipping-form select[name="country_id"]').find(":selected").text();
                        var regin;
                        if ($('#co-shipping-form input[name="region"]').is(':visible')) {
                            regin = $('#co-shipping-form input[name="region"]').val();
                        } else {
                            regin = region_select.find(":selected").text();
                        }
                        if(!registry.get('checkout.steps.shipping-step.shippingAddress.after-shipping-method-form.billing-address-form').isAddressSameAsShipping())
                        {
                            $('#submitBill').trigger('click');
                            if(quote.responseBillStatus() == 400)
                            {
                                return false;
                            }
                        }

                        $('#checkout-step-shipping').hide();
                        $('#shipping-text').show();
                        $('#shipping-text .main-address.shipping-address').html(firstname + ' ' + lastname + '<br>' + street + '<br>' + city + ', ' + regin + ', ' + country + '<br>' + postcode + ', ' + telephone + '<br>' + email);
                    }
                    $(paymentMethodObj[0]).find('input[type="radio"]').trigger('click');
                    $('#next-shipping').hide();
                    $('#edit-shipping').show();
                    $('#checkout-step-shipping_method').show();
                    $('#checkout-payment-method-load').show();
                    $('#checkout-step-payment,#opc-shipping_method').find('.step-title').removeClass('no-border');
                    if ($(window).width() < 768) {
                        var scrollTop = $('#opc-shipping_method').offset().top - 100;
                        $('html,body').animate({scrollTop: scrollTop}, 'fast');
                    }
                    checkoutDataResolver.resolveEstimationAddress();
                });

                $(document).on('click', '#shipping-text .address-edit', function () {
                    $('#shipping-text .main-address.shipping-address').html('');
                    $('#checkout_place_order').removeClass('button-fix');
                    $('#shipping-text').hide();
                    $('#checkout-step-shipping').show();
                    $('#next-shipping').show();
                    $('#edit-shipping').hide();
                    $('#checkout-step-shipping_method').hide();
                    $('#checkout-payment-method-load').hide();
                    $('#checkout-step-payment,#opc-shipping_method').find('.step-title').addClass('no-border');
                });
                $(document).on('click', '#billing-address-same-as-shipping-shared', function () {

                    if(!registry.get('checkout.steps.shipping-step.shippingAddress.after-shipping-method-form.billing-address-form').isAddressSameAsShipping())
                    {
                        $('#shipping-text .main-address.shipping-address').html('');
                        $('#checkout_place_order').removeClass('button-fix');
                        $('#shipping-text').hide();
                        $('#checkout-step-shipping').show();
                        $('#next-shipping').show();
                        $('#edit-shipping').hide();
                        $('#checkout-step-shipping_method').hide();
                        $('#checkout-payment-method-load').hide();
                        $('#checkout-step-payment,#opc-shipping_method').find('.step-title').addClass('no-border');
                    }
                });
                $(document).on('click', '#editLink', function () {
                    $('#shipping-text .main-address.shipping-address').html('');
                    $('#checkout_place_order').removeClass('button-fix');
                    $('#shipping-text').hide();
                    $('#checkout-step-shipping').show();
                    $('#next-shipping').show();
                    $('#edit-shipping').hide();
                    $('#checkout-step-shipping_method').hide();
                    $('#checkout-payment-method-load').hide();
                    $('#checkout-step-payment,#opc-shipping_method').find('.step-title').addClass('no-border');
                    if(!registry.get('checkout.steps.shipping-step.shippingAddress.after-shipping-method-form.billing-address-form').isAddressSameAsShipping())
                    {
                        $('#action-edit-address').trigger('click');
                    }
                });
            }
        });
    }
);
