<?php

namespace Joshine\CouponPusher\Model\Strategy;

use Joshine\CouponPusher\Block\CouponNopeAlert;

class NopePushStrategy implements ContractPushStrategy
{

    /**
     * @var \Magento\Framework\View\Element\BlockFactory
     */
    private $blockFactory;

    public function __construct(
        \Magento\Framework\View\Element\BlockFactory $blockFactory
    )
    {
        $this->blockFactory = $blockFactory;
    }

    public function push()
    {
        return $this->blockFactory->createBlock(CouponNopeAlert::class)->toHtml();
    }
}