<?php
namespace Joshine\CouponPusher\Helper;

class CustomerChecker implements \Magento\Framework\Data\CollectionDataSourceInterface
{
    const HAS_VISITED_COOKIE_KEY       = 'has_visited';
    const HAS_VISITED_COOKIE_DURATION  = 86400 * 30;

    protected $_cookieManager;

    protected $_dateTime;

    protected $_cookieMetadataFactory;

    private   $_request;

    public function __construct(
        \Magento\Framework\Stdlib\DateTime\DateTime $dateTime,
        \Magento\Framework\Stdlib\CookieManagerInterface $cookieManager,
        \Magento\Framework\Stdlib\Cookie\CookieMetadataFactory $cookieMetadataFactory,
        \Magento\Framework\App\RequestInterface $request
    )
    {
        $this->_cookieManager         = $cookieManager;
        $this->_cookieMetadataFactory = $cookieMetadataFactory;
        $this->_dateTime              = $dateTime;
        $this->_request               = $request;
    }

    public function checkFirstVisit(): bool
    {
        $previousTimestamp = $this->_cookieManager->getCookie(self::HAS_VISITED_COOKIE_KEY);
        if (!$previousTimestamp) {
            $metadata = $this->_cookieMetadataFactory
                ->createPublicCookieMetadata()
                ->setPath('/')
                ->setDuration(self::HAS_VISITED_COOKIE_DURATION);
            $this->_cookieManager->setPublicCookie(
                self::HAS_VISITED_COOKIE_KEY,
                'true',
                $metadata
            );
            return true;
        }
        return false;
    }

    //访客细分
    public function getCustomerSegments(): string
    {
        if ($this->checkFirstVisit()) {
            return Constant::FIRST_VISITOR;
        }
        return Constant::OTHER;
    }
}
