<?php

namespace Joshine\Category\Setup;

use Magento\Framework\Module\Setup\Migration;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Catalog\Setup\CategorySetupFactory;

/**
 * Data migration:
 * - Config Migration from version 2.0.1 JSON file store to 2.0.2+ Magento config way
 *
 */
class UpgradeData implements UpgradeDataInterface
{

    private $categorySetupFactory;

    public function __construct(CategorySetupFactory $categorySetupFactory)
    {
        $this->categorySetupFactory = $categorySetupFactory;
    }

    /**
     * Run data upgrade.
     *
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        $categorySetup = $this->categorySetupFactory->create(['setup' => $setup]);
        $entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Category::ENTITY);

        $attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);

        $categorySetup->addAttributeGroup(
            \Magento\Catalog\Model\Category::ENTITY,
            $categorySetup->getDefaultAttributeSetId(\Magento\Catalog\Model\Category::ENTITY),
            'Custom Menu',
            99
        );

        $menu_attributes = [
            'submenu_columns_total' =>
                [
                    'type'         => 'varchar',
                    'label'        => 'Submenu Columns Total',
                    'input'        => 'select',
                    'sort_order'   => 101,
                    'source'       => '\Joshine\Category\Model\Category\Attribute\Source\Columns',
                    'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                    'visible_on_front'  => true,
                    'required'     => false,
                    'user_defined' => false,
                    'default'      => null,
                    'group'        => 'Custom Menu',
                    'backend'      => ''
                ],
            'self_columns' =>
                [
                    'type'         => 'varchar',
                    'label'        => 'self_columns',
                    'input'        => 'select',
                    'sort_order'   => 101,
                    'source'       => '\Joshine\Category\Model\Category\Attribute\Source\Columns',
                    'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                    'visible_on_front'  => true,
                    'required'     => false,
                    'user_defined' => false,
                    'default'      => null,
                    'group'        => 'Custom Menu',
                    'backend'      => ''
                ],
            'submenu_columns_single' =>
                [
                    'type'         => 'varchar',
                    'label'        => 'Submenu Columns Single',
                    'input'        => 'select',
                    'sort_order'   => 101,
                    'source'       => '\Joshine\Category\Model\Category\Attribute\Source\Columns',
                    'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                    'visible_on_front'  => true,
                    'required'     => false,
                    'user_defined' => false,
                    'default'      => null,
                    'group'        => 'Custom Menu',
                    'backend'      => ''
                ],
            'menu_image' =>
            [
                'type'         => 'varchar',
                'label'        => 'badge',
                'visible_on_front'  => true,
                'user_defined' => false,
                'default'      => null,
                'group'        => 'Custom Menu',
                'input'        => 'image',
                'backend'      => 'Magento\Catalog\Model\Category\Attribute\Backend\Image',
                'required'     => false,
                'sort_order'   => 70,
                'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
            ],
            'is_show_size'=>
            [
                'type'         => 'int',
                'label'        => 'badge',
                'visible_on_front'  => true,
                'user_defined' => false,
                'default'      => 0,
                'group'        => '',
                'input'        => 'checkbox',
                'backend'      => '',
                'required'     => false,
                'sort_order'   => 100,
                'global'       =>  \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
            ]
        ];

        foreach($menu_attributes as $item => $data) {
            $categorySetup->addAttribute(\Magento\Catalog\Model\Category::ENTITY, $item, $data);
        }

        $idg =  $categorySetup->getAttributeGroupId($entityTypeId, $attributeSetId, 'Custom Menu');

        foreach($menu_attributes as $item => $data) {
            $categorySetup->addAttributeToGroup(
                $entityTypeId,
                $attributeSetId,
                $idg,
                $item,
                $data['sort_order']
            );
        }
        $setup->endSetup();
    }
}
