<?php
namespace Joshine\Review\Helper;

use Joshine\Review\Block\Images;
use Joshine\Review\Block\Review\ToolBar;

class BlockHelper implements \Magento\Framework\Data\CollectionDataSourceInterface
{

    /**
     * @var \Magento\Framework\View\Element\BlockFactory
     */
    private $blockFactory;


    /**
     * @var \Magento\Framework\Stdlib\StringUtils
     */
    private $stringUtils;

    /**
     * @var \Magento\Customer\Model\SessionFactory
     */
    private $sessionFactory;

    /**
     * @var \Magento\Framework\Escaper
     */
    private $escaper;

    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    public function __construct(
        \Magento\Framework\View\Element\BlockFactory $blockFactory,
        \Magento\Framework\Stdlib\StringUtils $stringUtils,
        \Magento\Customer\Model\SessionFactory $sessionFactory,
        \Magento\Framework\Escaper $escaper,
        \Magento\Framework\UrlInterface $urlBuilder,
        \Magento\Framework\App\RequestInterface $request
    ) {
        $this->blockFactory = $blockFactory;
        $this->stringUtils = $stringUtils;
        $this->sessionFactory = $sessionFactory;
        $this->escaper = $escaper;
        $this->urlBuilder = $urlBuilder;
        $this->request = $request;
    }
    public function getReviewImagesHtml($reviewId, $productId)
    {
        $html = '';
        $block = $this->blockFactory
            ->createBlock(Images::class)
            ->setProductId($productId)
            ->setReviewId($reviewId);
        if ($block) {
            $html = $block->toHtml();
        }
        return $html;
    }

    public function getToolBarHtML()
    {
        return $this->blockFactory
            ->createBlock(ToolBar::class)
            ->toHtml();
    }


    public function getReviewImagesBlock($reviewId, $productId) : Images
    {
        return $this->blockFactory
            ->createBlock(Images::class)
            ->setProductId($productId)
            ->setReviewId($reviewId);
    }

    public function translateSizeFits($value)
    {
        $default = __('True to Size');
        if (intval($value) == 1) {
            return __('Small');
        }

        if (intval($value) == 2) {
            return __('True to Size');
        }

        if (intval($value) == 3) {
            return __('Large');
        }
        return $default;
    }

    static function getRealIp()
    {
        if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            $ips = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }elseif(!empty($_SERVER['HTTP_CLIENT_IP'])){
            $ips = $_SERVER['HTTP_CLIENT_IP'];
        }else{
            $ips = $_SERVER['REMOTE_ADDR'];
        }

        if (strpos($ips, ',') !== false) {
            $ipList = explode(',', $ips);
        } else {
            $ipList = [$ips];
        }
        $remoteAddress = trim(reset($ipList));
        return $remoteAddress ?? '';
    }

}
