<?php
namespace Joshine\Review\Block\Review\Product\View;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\DataObjectFactory;
use Magento\Review\Model\ResourceModel\Review\Collection as ReviewCollection;

use Magento\Review\Model\Review\SummaryFactory;

use Joshine\Review\Block\Components\Pager;

class ListView extends \Magento\Review\Block\Product\View\ListView
{
    const VOTED_CLASS_NAME = 'active';

    /**
     * @var \Magento\Review\Model\Review\SummaryFactory
     */
    private $summaryModFactory;

    private $dataObjectFactory;

    /**
     * @var ReviewCollection
     */
    private $reviewsCollection;

    private $reviewsColFactory;

    private $voteRepository;

    private $vote;

    private $formKey;

    /**
     * @var \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     */
    private $remoteAddress;

    public function __construct(
        DataObjectFactory $dataObjectFactory,
        SummaryFactory $summaryModFactory,
        \Magento\Framework\Data\Form\FormKey $formKey,
        \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress,
        \Joshine\Review\Model\Repository\VoteRepository $voteRepository,
        \Magento\Review\Model\ResourceModel\Review\CollectionFactory  $reviewsColFactory,
        \Magento\Catalog\Block\Product\Context $context, \Magento\Framework\Url\EncoderInterface $urlEncoder, \Magento\Framework\Json\EncoderInterface $jsonEncoder, \Magento\Framework\Stdlib\StringUtils $string, \Magento\Catalog\Helper\Product $productHelper, \Magento\Catalog\Model\ProductTypes\ConfigInterface $productTypeConfig, \Magento\Framework\Locale\FormatInterface $localeFormat, \Magento\Customer\Model\Session $customerSession, ProductRepositoryInterface $productRepository, \Magento\Framework\Pricing\PriceCurrencyInterface $priceCurrency, \Magento\Review\Model\ResourceModel\Review\CollectionFactory $collectionFactory, array $data = [])
    {
        $this->summaryModFactory = $summaryModFactory;
        $this->dataObjectFactory = $dataObjectFactory;
        $this->reviewsColFactory = $reviewsColFactory;
        $this->voteRepository    = $voteRepository;
        $this->formKey           = $formKey;
        $this->remoteAddress     = $remoteAddress;
        parent::__construct($context, $urlEncoder, $jsonEncoder, $string, $productHelper, $productTypeConfig, $localeFormat, $customerSession, $productRepository, $priceCurrency, $collectionFactory, $data);
    }
    
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if ($this->getReviewsCollection()) {
            $pager = $this->getLayout()->createBlock(
                Pager::class
            )->setCollection(
                $this->getLimitedReviewsCollection()
            )->setData($this->getData())
            ->setProductId($this->getProductId());
            $this->setChild('pager', $pager);
            $this->getLimitedReviewsCollection()->load();
        }
        return $this;
    }

    public function setSummary($product, $displayedCollection)
    {
        $storeId = $this->_storeManager->getStore()->getId();

        $summaryData = $this->summaryModFactory->create()
            ->setStoreId($storeId)
            ->load($product->getId());

        $summary = $this->dataObjectFactory->create();
        $summary->setData($summaryData->getData());
        $product->setRatingSummary($summary);
    }

    public function getRatingSummary()
    {
        $result = null;
        $summary = $this->getProduct()->getRatingSummary();
        if ($summary) {
            $result = $summary->getRatingSummary();
        }
        return $result;
    }

    function getRatingSummaryValue(): float
    {
        $value = $this->getRatingSummary();
        $value = $value / 100 * 5;
        return round($value, 1);
    }

    public function getDetailedSummary(): array
    {
        $result = [
            '3' => 0,
            '2' => 0,
            '1' => 0
        ];
        $reviews = $this->reviewsColFactory->create()->addStoreFilter(
            $this->_storeManager->getStore()->getId()
        )->addStatusFilter(
            \Magento\Review\Model\Review::STATUS_APPROVED
        )->addEntityFilter(
            'product',
            $this->getProduct()->getId()
        );
        foreach ($reviews as $item) {
            if($item->getSizeFits() != 0 ){
                $key = $item->getSizeFits();
                $result[$key] = $result[$key] + 1;
            }
        }

        return $result;
    }

    /**
     * Get collection of reviews
     *
     * @return ReviewCollection
     */
    public function getReviewsCollection()
    {
        if (null === $this->reviewsCollection) {
            $this->reviewsCollection = $this->reviewsColFactory->create()->addStoreFilter(
                $this->_storeManager->getStore()->getId()
            )->addStatusFilter(
                \Magento\Review\Model\Review::STATUS_APPROVED
            )->addEntityFilter(
                'product',
                $this->getProduct()->getId()
            )->setDateOrder();
        }
        return $this->reviewsCollection;
    }

    public function getReviewsCount() : int
    {
        return $this->getReviewsCollection()->getSize();
    }

    public function getLimitedReviewsCollection(): ReviewCollection
    {
        $page = $this->getRequest()->getParam('p') ?? 1;
        return $this->getReviewsCollection()->clear()
            ->setPageSize(Pager::DEFAULT_PAGE_SIZE)
            ->setCurPage((int)$page)
            ->load()->addRateVotes();
    }

    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    private function getVote($reviewId)
    {
        return $this->voteRepository->getVotesCount($reviewId);
    }

    public function getPlusReview($reviewId)
    {
        $vote = $this->getVote($reviewId);

        return $vote['plus'];
    }

    /**
     * @return string
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getFormKey(): string
    {
        return $this->formKey->getFormKey();
    }

    /**
     * @return string
     */
    public function getPlusVotedClass($reviewId)
    {
        $result = '';
        if ($this->isPlusVoted($reviewId)) {
            $result = self::VOTED_CLASS_NAME;
        }
        return $result;
    }

    private function getVotedByIp($reviewId)
    {
        return $this->voteRepository->getVotesCount(
            $reviewId,
            $this->remoteAddress->getRemoteAddress()
        );
    }
    public function isPlusVoted($reviewId)
    {
        $voted = $this->getVotedByIp($reviewId);

        return $voted['plus'] > 0;
    }

}
