/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'underscore',
    'Magento_Checkout/js/view/summary/abstract-total',
    'Magento_Checkout/js/model/quote',
    'Magento_SalesRule/js/view/summary/discount'
], function ($, _, Component, quote, discountView) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_Checkout/summary/shipping'
        },
        quoteIsVirtual: quote.isVirtual(),
        totals: quote.getTotals(),

        /**
         * @return {*}
         */
        getShippingMethodTitle: function () {
            var shippingMethod,
                shippingMethodTitle = '';

            if (!this.isCalculated()) {
                return '';
            }


            var price;

            if (!this.isCalculated()) {
                return this.notCalculatedMessage;
            }
            price =  this.totals()['shipping_amount'];
            if(price == 0)
            {
                if(quote.shippingSaveMethod())
                {
                    return quote.shippingSaveMethod()['method_title'];
                }
            }
            shippingMethod = quote.shippingMethod();

            if (!_.isArray(shippingMethod) && !_.isObject(shippingMethod)) {
                return '';
            }

            if (typeof shippingMethod['method_title'] !== 'undefined') {
                shippingMethodTitle = shippingMethod['method_title'];
            }

            return shippingMethodTitle ? shippingMethodTitle :
                shippingMethod['carrier_title'];
        },
        getShippingSaveMethodTitle: function () {
            return ' Save';
        },

        /**
         * @return {*|Boolean}
         */
        isCalculated: function () {
            return this.totals() && this.isFullMode() && quote.shippingMethod() != null; //eslint-disable-line eqeqeq
        },
        isSaveShowed: function () {
            var price =  this.totals()['shipping_amount'];
            if(price != 0 || quote.shippingSaveMethod() == null)
            {
                return false;
            }
            return true;
        },

        /**
         * @return {*}

         getValue: function () {
            var price;

            if (!this.isCalculated()) {
                return this.notCalculatedMessage;
            }
            price =  this.totals()['shipping_amount'];

            return this.getFormattedPrice(price);
        },

         */
        getValue: function () {
            var price;

            if (!this.isCalculated()) {
                return this.notCalculatedMessage;
            }
            price =  this.totals()['shipping_amount'];
            if(price == 0)
            {
                if(quote.shippingSaveMethod() && quote.shippingSaveMethod()['amount'] != 0)
                {
                    return this.getFormattedPrice(quote.shippingSaveMethod()['amount']);
                }
                else
                {
                    return window.checkoutConfig.flatrate_price;
                }
            }
            return this.getFormattedPrice(price);
        },
        getSaveValue: function () {
            var price;

            if (!this.isCalculated()) {
                return this.notCalculatedMessage;
            }
            price =  this.totals()['shipping_amount'];
            if(price == 0)
            {
                if(quote.shippingSaveMethod() && quote.shippingSaveMethod()['amount'] != 0)
                {
                    return '-'+this.getFormattedPrice(quote.shippingSaveMethod()['amount']);
                }
                else
                {
                    return '-'+window.checkoutConfig.flatrate_price;
                }
            }
            return 0;
        },

        /**
         * If is set coupon code, but there wasn't displayed discount view.
         *
         * @return {Boolean}
         */
        haveToShowCoupon: function () {
            var couponCode = this.totals()['coupon_code'];

            if (typeof couponCode === 'undefined') {
                couponCode = false;
            }

            return couponCode && !discountView().isDisplayed();
        },

        /**
         * Returns coupon code description.
         *
         * @return {String}
         */
        getCouponDescription: function () {
            if (!this.haveToShowCoupon()) {
                return '';
            }

            return '(' + this.totals()['coupon_code'] + ')';
        }
    });
});
