/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'uiComponent',
    'ko',
    'Magento_Checkout/js/model/quote',
    'mage/mage'
], function ($, Component,ko,quote) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_Checkout/logo-nav'
        },
        visible: ko.observable(!quote.isVirtual()) && ko.observable(window.checkoutConfig.addressVisible),
        shippingVisible: ko.observable(window.checkoutConfig.shippingVisible),
        paymentVisible: ko.observable(window.checkoutConfig.paymentVisible),
        getLogoSrc: function(){
            return window.checkoutConfig.logosrc;
        },
        breadcrumbReturnToCart: function(){
            $.mage.redirect(window.checkoutConfig.cartUrl);
        },
        isMobile: function(){
            return window.checkoutConfig.isMobile;
        }
    });
});
