<?php

namespace Joshine\Script\Console\Command;


use Joshine\Script\Model\ImageQueryResource;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
class ProductFirstImageAsBaseFixer extends Command
{

    protected $imageQueryResource;

    protected $productRepository;

    protected $searchCriteriaBuilder;

    public function __construct(
        ImageQueryResource $imageQueryResource,
        ProductRepositoryInterface $productRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        string $name = null)
    {
        $this->imageQueryResource    = $imageQueryResource;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->productRepository = $productRepository;
        parent::__construct($name);
    }

    protected function configure()
    {
        $this->setName('joshine:fix-base-image')->setDescription('设置第一张产品图为base image');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $collection  = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\Collection')->addFilter('type_id', 'configurable', 'eq');

        foreach ($collection as $item) {
            $pid = $item->getId();
            $this->fixBaseImage($input, $output, $pid);
        }
    }

    protected function fixBaseImage($input, $output, $productId)
    {
        $mainImage = $this->imageQueryResource->getProductMainImage($productId);

        $firstImage = $this->imageQueryResource->getFirstImages($productId);
        $output->writeln('first image' . $firstImage);
        $output->writeln("main image".$mainImage);

        if (empty($firstImage)) {
            $output->writeln('first image is null, break');
            return;
        }

        if (empty($mainImage)) {
            $output->writeln('base image is null, break');
            return;
        }

        $lastImage = $this->imageQueryResource->getLastImage($productId);
        if ($mainImage != $lastImage) {
            $output->writeln('base image not last, break');
            return;
        }

        if ($mainImage != $firstImage) {
            $output->writeln('fix product ' . $mainImage . ' product id: ' . $productId);
            //change main image
            $this->imageQueryResource->changeBaseImageTo($productId, $firstImage);
        }
    }
}