<?php

namespace Joshine\Sales\Plugin;

use Magento\Catalog\Model\ProductFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\OrderItemExtensionFactory;
use Magento\Sales\Api\Data\OrderItemExtensionInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Api\Data\OrderItemInterface;
use Magento\Sales\Api\Data\OrderItemSearchResultInterface;
use Magento\Sales\Api\OrderItemRepositoryInterface;
use Magento\Catalog\Helper\Image;

/**
 * Class OrderItemRepositoryPlugin
 */
class OrderRepositoryPlugin
{
    /**
     * Order feedback field name
     */
    const FIELD_NAME = 'image_url';

    /**
     * @var OrderItemExtensionFactory
     */
    private $orderItemExtensionFactory;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var \Magento\Sales\Api\ProductRepositoryInterfaceFactory
     */
    private $productRepository;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private $_productRepository;
    /**
     * @var Image
     */
    private $imageHelper;
    /**
     * @var ProductFactory
     */
    private $productFactory;

    public function __construct(
        OrderRepositoryInterface $orderRepository,
        \Magento\Sales\Api\Data\OrderItemExtensionFactory $orderItemExtensionFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\Catalog\Helper\Image $imageHelper,
        ProductFactory $productFactory
    )
    {
        $this->orderItemExtensionFactory = $orderItemExtensionFactory;
        $this->orderRepository    = $orderRepository;
        $this->_productRepository = $productRepository;
        $this->imageHelper        = $imageHelper;
        $this->productFactory     = $productFactory;
    }

    public function afterGet(OrderRepositoryInterface $subject, OrderInterface $quote)
    {
        return $this->setAttributeValue($quote);
    }

    private function setAttributeValue($quote) {
        foreach ($quote->getItems() as $item) {
            $extensionAttributes = $item->getExtensionAttributes();
            if ($extensionAttributes === null) {
                $extensionAttributes = $this->orderItemExtensionFactory->create();
            }
            $extensionAttributes->setImage("null");
            $product = $this->_productRepository->get($item->getSku());
            if ($product) {
                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $storeManager = $objectManager->get('\Magento\Store\Model\StoreManagerInterface');
                $hostname = $storeManager->getStore()->getBaseUrl();
                $extensionAttributes->setImage($hostname."media/catalog/product/".$product->getData('thumbnail'));
            }
        }

        return $quote;
    }
}