<?php
namespace Joshine\Sales\Plugin;

use \Magento\Catalog\Helper\Image as ImageHelper;
use Magento\Sales\Block\Adminhtml\Order\View\Items\Renderer\DefaultRenderer;

class DefaultRendererPlugin {

    /**
     * @var \Magento\Catalog\Helper\Image $imageHelper
     */
    protected $imageHelper;

    /**
     * @param ImageHelper      $imageHelper
     */
    public function __construct
    (
        ImageHelper $imageHelper
    )
    {
        $this->imageHelper      = $imageHelper;
    }

    public function aroundGetColumnHtml(\Magento\Sales\Block\Adminhtml\Order\View\Items\Renderer\DefaultRenderer $defaultRenderer, \Closure $proceed,\Magento\Framework\DataObject $item, $column, $field=null) {
        $result = '';
        if($column === 'image') {
            if ($item->getProduct()) {
                $img = $this->imageHelper->init($item->getProduct(), 'cart_page_product_thumbnail')->setImageFile($item->getProduct()->getImage())->resize(100)->getUrl();
                $result = '<img src="'.$img.'" alt="'.$item->getName().'" />';
            }
        }
        else {
            if($field) {
                $result = $proceed($item,$column,$field);
            }
            else {
                $result = $proceed($item,$column);
            }
        }

        return $result;
    }

    public function afterGetColumns(DefaultRenderer $subject, $result)
    {
        if (isset($result['image'])) {
            unset($result['image']);
            $result = array_merge(['image'=>'col-image'], $result);
        }
        return $result;
    }
}