<?php

namespace Joshine\CouponPusher\Model;

use Joshine\CouponPusher\Helper\Constant;
use Joshine\CouponPusher\Helper\CustomerChecker;
use Joshine\CouponPusher\Model\Strategy\ContractPushStrategy;
use Joshine\CouponPusher\Model\Strategy\SubscribePushStrategy;
use Joshine\CouponPusher\Model\Strategy\StopPushStrategy;
use Magento\Framework\ObjectManagerInterface;

class PushStrategyManager
{
    protected $_customerChecker;

    protected $_objectManger;
    public function __construct(
        CustomerChecker $customerChecker,
        ObjectManagerInterface $objectManager
    )
    {
        $this->_customerChecker = $customerChecker;
        $this->_objectManger    = $objectManager;
    }

    public function tagToStrategy($tag): string
    {
        $map = [
            //第一次访问推送订阅券
            Constant::FIRST_VISITOR => SubscribePushStrategy::class,

            //未订阅，持续推送订阅券
            Constant::NOT_SUBSCRIBE => SubscribePushStrategy::class,

            //已订阅停止推送
            Constant::HAS_SUBSCRIBE => StopPushStrategy::class,
        ];

        if (!isset($map[$tag])) {
            return StopPushStrategy::class;
        }
        return $map[$tag];
    }

    public function getPushTemplate() {
        $tag          = $this->_customerChecker->getCustomerSegments();
        $strategyName = $this->tagToStrategy($tag);
        /**
         * @var $strategy ContractPushStrategy
         */
        $strategy = $this->_objectManger->create($strategyName);
        return $strategy->push();
    }
}