<?php

namespace Joshine\CouponPusher\Model;

use Joshine\CouponPusher\Helper\Constant;
use Joshine\CouponPusher\Helper\CustomerChecker;
use Joshine\CouponPusher\Model\Strategy\ContractPushStrategy;
use Joshine\CouponPusher\Model\Strategy\FirstVisitorPushStrategy;
use Joshine\CouponPusher\Model\Strategy\NopePushStrategy;
use Magento\Framework\ObjectManagerInterface;

class PushStrategyManager
{
    protected $_customerChecker;

    protected $_objectManger;
    public function __construct(
        CustomerChecker $customerChecker,
        ObjectManagerInterface $objectManager
    )
    {
        $this->_customerChecker = $customerChecker;
        $this->_objectManger    = $objectManager;
    }

    public function tagToStrategy($tag): string
    {
        $map = [
            Constant::FIRST_VISITOR => FirstVisitorPushStrategy::class,
        ];
        if (!isset($map[$tag])) {
            return NopePushStrategy::class;
        }
        return $map[$tag];
    }

    public function getPushTemplate() {
        $tag          = $this->_customerChecker->getCustomerSegments();
        $strategyName = $this->tagToStrategy($tag);
        /**
         * @var $strategy ContractPushStrategy
         */
        $strategy = $this->_objectManger->create($strategyName);
        return $strategy->push();
    }
}