<?php
namespace Joshine\CouponPusher\Controller\Ajax;

use Joshine\CouponPusher\Helper\CustomerChecker;
use Joshine\CouponPusher\Model\PushStrategyManager;
use Magento\Catalog\Model\ProductFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Exception\LocalizedException;

class CouponPusher  extends \Magento\Framework\App\Action\Action {

    protected $subscriptionManager;

    protected $customerChecker;

    protected $pushStrategyManager;

    protected $formKeyValidator;

    protected $remoteAddress;

    protected $logger;

    protected $jsonEncoder;

    protected $resultJsonFactory;

    public function __construct(
        Context $context,
        CustomerChecker $customerChecker,
        PushStrategyManager $pushStrategyManager,
        \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator,
        \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\Json\EncoderInterface $jsonEncoder,
        JsonFactory $resultJsonFactory
    )
    {
        parent::__construct($context);
        $this->customerChecker      = $customerChecker;
        $this->pushStrategyManager  = $pushStrategyManager;
        $this->formKeyValidator     = $formKeyValidator;
        $this->remoteAddress        = $remoteAddress;
        $this->logger               = $logger;
        $this->jsonEncoder          = $jsonEncoder;
        $this->resultJsonFactory    = $resultJsonFactory;
    }

    public function execute()
    {
        $message = [
            'error' => __('Sorry. There is a problem with your Request.')
        ];

        if ($this->getRequest()->isAjax()) {

            try {
                if (!$this->formKeyValidator->validate($this->getRequest())) {
                    throw new LocalizedException(
                        __('Form key is not valid. Please try to reload the page.')
                    );
                }
                $message = [
                    'success' => __('Success.'),
                    'data'    => $this->pushStrategyManager->getPushTemplate(),
                ];

            } catch (LocalizedException $e) {
                $message = ['error' => $e->getMessage()];
            } catch (\Exception $e) {
                $this->logger->error($e->getMessage());
            }
        }
        $resultPage = $this->resultJsonFactory->create();
        $resultPage->setHttpResponseCode(200);
        $resultPage->setData($message);
        return $resultPage;
    }
}