<?php
namespace Joshine\Banner\Controller\Adminhtml\Index;

use \Magento\Backend\App\Action;
use \Magento\Backend\App\Action\Context;
use \Magento\Framework\View\Result\PageFactory;
use \Magento\Framework\Registry;
use Magento\Shipping\Model\Rate\ResultFactory;
use Joshine\Banner\Model\BassFactory;
class Edit extends Action
{
    const ADMIN_RESOURCE = "Joshine_Banner::index";

    protected $_coreRegistry;
    protected $resultPageFactory;
    protected $factory;

    public function __construct
    (
        Context $context,
        PageFactory $pageFactory,
        Registry $registry,
        BassFactory $factory
    )
    {
        $this->factory = $factory;
        $this->_coreRegistry = $registry;
        $this->resultPageFactory = $pageFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        // TODO: Implement execute() method.
        $id = $this->getRequest()->getParam('id');
        $model = $this->_objectManager->create(\Joshine\Banner\Model\Bass::class);

        if ($id){
            $model->load($id);
            if (!$model->getId()){
                $this->messageManager->addErrorMessage(__('This banner no longer exists.'));
                $resultRedirect = $this->resultRedirectFactory->create();
                return $resultRedirect->setPath('*/*/');
            }
        }

        $this->_coreRegistry->register('banner',$model);
        $resultPage = $this->resultPageFactory->create();

        $resultPage->getConfig()->getTitle()->prepend($id? __('Edit Banner') : __('New Banner'));

        return $resultPage;

    }



}