<?php
namespace JTool\toolbar\Plugin\Catalog\Block;
class Toolbar
{
    public function aroundSetCollection(\Magento\Catalog\Block\Product\ProductList\Toolbar $subject,
                                        \Closure $proceed, $collection)
    {
        //ordered_qty
        $currentOrder = $subject->getCurrentOrder();
        $this->_collection = $collection;
        $result = $proceed($collection);
        if($currentOrder)
        {
            if($currentOrder == 'high_to_low')
            {
                $subject->getCollection()->setOrder('price', 'desc');
            }
            elseif ($currentOrder == 'low_to_high')
            {
                $subject->getCollection()->setOrder('price', 'asc');
            }
            elseif ($currentOrder == 'new_arrivals')
            {
                $this->_collection->getSelect()->order('e.created_at DESC');
            }
            elseif ($currentOrder == 'best_seller')
            {
                $subject->getCollection()->getSelect()->joinLeft(
                    'sales_order_item',
                    'e.entity_id = sales_order_item.product_id',
                    array('qty_ordered'=>'(select sum(soi.qty_ordered) from sales_order_item soi where soi.product_id = e.entity_id)'))->distinct(true)
                    ->order('qty_ordered desc');
            }
        }
        return $result;
    }
}