/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'mage/mage'
], function ($) {
    'use strict';

    return function (config, element) {
        $(element).mage('validation', {
            /** @inheritdoc */
            errorPlacement: function (error, el) {
                if (el.parents('#product-review-table').length) {
                    $('#product-review-table').siblings(this.errorElement + '.' + this.errorClass).remove();
                    $('#product-review-table').after(error);
                } else if(el.parents('.options-list').length ) {
                    $('.options-list').siblings(this.errorElement + '.' + this.errorClass).remove();
                    $('.options-list').after(error);
                } else  {
                    el.after(error);
                }
            }
        });
    };
});
