(function () {
    'use strict';

    $.widget('slideout', {
        component: 'slideout',
        options: {
            active: 'active'
        },

        /** [create description] */
        create: function () {
            this.toggler = this.element.find(this.options.toggler);
            this.panel = this.element.find(this.options.panel);
            this.focusTrap = this.createFocusTrap(this.panel);
            this.closeBtn = $('<button>').addClass('button-close filter-content-close');
            this.panel.prepend(this.closeBtn);

            this._on(document, {
                keydown: function (e) {
                    if (e.key === 'Escape' && this.element.hasClass(this.options.active)) {
                        this.close();
                    }
                }.bind(this)
            });

            this._on(this.toggler, {
                click: this.toggle,
                keydown: function (e) {
                    if (e.key === 'Enter' || e.key === ' ') {
                        e.preventDefault();
                        this.toggle();
                    }
                }.bind(this)
            });

            this._on(this.closeBtn, {
                click: this.close
            });
        },

        /** [destroy description] */
        destroy: function () {
            this.close();
            this.closeBtn.remove();
            this._super();
        },

        /** [toggle description] */
        toggle: function () {
            if (this.element.hasClass(this.options.active)) {
                this.close();
            } else {
                this.open();
            }
        },

        /** [open description] */
        open: function () {
            if (this.panel.css('visibility') !== 'hidden') {
                return;
            }

            $.breeze.scrollbar.hide();
            this.panel.one('transitionend', this.focusTrap.activate);
            this.element.addClass(this.options.active);
        },

        /** [close description] */
        close: function () {
            $.breeze.scrollbar.reset();
            this.focusTrap.deactivate();
            this.element.removeClass(this.options.active);
        }
    });

    $(document).on('breeze:load', function () {
        if ($('body').var('--swatches-over-image')) {
            $.async([
                '.products-grid .product-item-details [class^="swatch-opt-"]',
                '[data-appearance="carousel"] .product-item-details [class^="swatch-opt-"]',
            ].join(','), function (el) {
                $(el).appendTo($(el).closest('.product-item-info').find('.product-item-photo'));
            })
            $(document).on('click', 'a [class^="swatch-opt-"]', function (e) {
                e.preventDefault();
            });
        }

        $.async('.breeze-carousel .products-grid', (el) => {
            $(el).pagebuilderCarousel({
                arrows: true
            });
            $(el).parents('.hide.show-on-ready').removeClass('hide');
        });

        if ($('body').var('--header-panel-slideout')) {
            $('.panel.header')
                .clone()
                .removeClass('header panel')
                .addClass('mobile-header-panel')
                .data('breeze-temporary', true)
                .appendTo($('.navigation-wrapper'));
        }
    });
})();
