<?php
/**
 * NOTICE OF LICENSE
 * You may not sell, distribute, sub-license, rent, lease or lend complete or portion of software to anyone.
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * @package   RLTSquare_ProductReviewImages
 * @copyright Copyright (c) 2022 RLTSquare (https://www.rltsquare.com)
 * @contacts  support@rltsquare.com
 * @license  See the LICENSE.md file in module root directory
 */

namespace RLTSquare\ProductReviewImages\Observer;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\Driver\File;
use RLTSquare\ProductReviewImages\Model\ReviewMediaFactory;
use RLTSquare\ProductReviewImages\Model\ResourceModel\ReviewMedia;
/**
 * Class AdminProductReviewSaveAfter
 *
 * @package RLTSquare\ProductReviewImages\Observer
 * @author Umar Chaudhry <umarch@rltsquare.com>
 */
class AdminProductReviewSaveAfter implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var RequestInterface
     */
    protected RequestInterface $request;

    /**
     * @var ReviewMediaFactory
     */
    protected ReviewMediaFactory $reviewMediaFactory;

    /**
     * @var DirectoryList::MEDIA
     */
    protected DirectoryList $mediaDirectory;

    /**
     * @var File
     */
    protected File $_fileHandler;

    /**
     * @var ReviewMedia
     */
    protected ReviewMedia $reviewMediaResourceModel;

    /**
     * AdminProductReviewSaveAfter constructor.
     * @param RequestInterface $request
     * @param Filesystem $filesystem
     * @param File $fileHandler
     * @param ReviewMediaFactory $reviewMediaFactory
     * @param ReviewMedia $reviewMediaResourceModel
     * @throws FileSystemException
     */
    public function __construct(
        RequestInterface $request,
        Filesystem $filesystem,
        File $fileHandler,
        ReviewMediaFactory $reviewMediaFactory,
        ReviewMedia $reviewMediaResourceModel
    )
    {
        $this->request = $request;
        $this->fileHandler = $fileHandler;
        //$this->mediaDirectory = $filesystem->getDirectoryWrite(DirectoryList::MEDIA);
        $this->reviewMediaFactory = $reviewMediaFactory;
        $this->reviewMediaResourceModel = $reviewMediaResourceModel;
    }


    /**
     * function
     * executes after review is saved
     *
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer): void
    {
        //$target = $this->mediaDirectory->getAbsolutePath('review_images');
        $deletedMediaString = $this->request->getParam('deleted_media');

        if ($deletedMediaString)
            try {
                $ids = explode(",", trim($deletedMediaString, ","));
                foreach ($ids as $id) {
                    $reviewMedia = $this->reviewMediaFactory->create()->load($id);
//                    $path = $target . $reviewMedia->getMediaUrl();
//                    if ($this->_fileHandler->isExists($path)) {
//                        $this->_fileHandler->deleteFile($path);
//                    }
                    //$reviewMedia->delete();
                    $this->reviewMediaResourceModel->delete($reviewMedia);
                }
            } catch (\Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong while updating review attachment(s).'));
            }
    }
}
