<?php
namespace Joshine\Review\Plugin\Review\Model;

use Joshine\Review\Model\ImageUploader;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Review\Block\Form as MagentoForm;
use Magento\Framework\Exception\LocalizedException;
use Magento\Review\Model\Review as MagentoReview;

class Review {


    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    /**
     * @var ImageUploader
     */
    private $imageUploader;

    /**
     * @var \Joshine\Review\Model\ImagesFactory
     */
    private $imagesFactory;

    private $imagesResource;

    private $messageManager;

    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        ImageUploader $imageUploader,
        \Joshine\Review\Model\ImagesFactory $imagesFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Joshine\Review\Model\ResourceModel\Images $imagesResource
    )
    {
        $this->messageManager = $messageManager;
        $this->imagesFactory = $imagesFactory;
        $this->imageUploader = $imageUploader;
        $this->request = $request;
        $this->imagesResource = $imagesResource;
    }

    public function afterAggregate(
        MagentoReview $subject,
                      $result
    ) {

        $this->uploadReviewImages($subject);

        return $result;
    }

    public function uploadReviewImages(MagentoReview $subject) {
        $files = $this->request->getFiles('review_images');
        $reviewId = $subject->getReviewId();

        //todo:: 用helper方法做是否允许上传图片的判断
        if ($files && $reviewId) {
            foreach ($files as $fileId => $file) {
                if (UPLOAD_ERR_OK == $file['error']) {
                    $this->uploadImage($file, $reviewId);
                }
            }
        }
    }

    public function uploadImage($file, $reviewId) {

        try {
            $result = $this->imageUploader->execute($file);
            $this->saveImage($result, $reviewId);
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('An error occurred while uploading the image.'));
            throw new LocalizedException(__($e->getMessage()));
        }


        return $this;
    }

    /**
     * @throws NoSuchEntityException
     * @throws CouldNotSaveException
     */
    private function saveImage($result, $reviewId)
    {
        /** @var \Joshine\Review\Model\Images $model */
        $model = $this->imagesFactory->create();
        $model->setReviewId($reviewId);
        $model->setPath($result['file']);

        if ($model->getImageId()) {
            $model = $this->getFullImage($model->getImageId())->addData($model->getData());
        }

        try {
            $this->imagesResource->save($model);
        } catch (\Exception $e) {
            if ($model->getImageId()) {
                throw new CouldNotSaveException(
                    __('Unable to save image with ID %1. Error: %2', [$model->getImageId(), $e->getMessage()])
                );
            }
            throw new CouldNotSaveException(__('Unable to save new image. Error: %1', $e->getMessage()));
        }
    }

    private function getFullImage($imageId) {
        $image = $this->imagesFactory->create();
        $this->imagesResource->load($image, $imageId);
        if (!$image->getImageId()) {
            throw new NoSuchEntityException(__('Rule with specified ID "%1" not found.', $imageId));
        }
        return $image;
    }

}
