<?php

namespace Joshine\Review\Plugin\Review\Controller\Adminhtml\Product\Review;

use Magento\Review\Controller\Adminhtml\Product\Save as MagentoReview;
class Save
{

    private $imagesRepository;

    public function __construct(
        \Joshine\Review\Model\Repository\ImagesRepository $imagesRepository
    ) {
        $this->imagesRepository = $imagesRepository;
    }

    /**
     * @param MagentoReview $subject
     * @param $result
     * @return mixed
     */
    public function afterExecute(
        MagentoReview $subject,
        $result
    ) {
        $this->removeImages($subject);

        return $result;
    }

    /**
     * @param MagentoReview $subject
     */
    private function removeImages(MagentoReview $subject)
    {
        $images = $subject->getRequest()->getParam('review_remove_image', []);
        if (is_array($images)) {
            foreach ($images as $id => $image) {
                $this->imagesRepository->deleteById($id);
            }
        }
    }
}
