<?php

namespace Joshine\Review\Plugin\Review\Block\Adminhtml\Edit;

use Joshine\Review\Helper\BlockHelper as BlockHelper;
use Joshine\Review\Model\Repository\VoteRepository;
use Magento\Backend\Block\Widget\Form\Generic as MagentoForm;

class Form
{

    /**
     * @var \Magento\Framework\Registry
     */
    private $registry;

    /**
     * @var VoteRepository
     */
    private $voteRepository;

    /**
     * @var BlockHelper
     */
    private $blockHelper;


    /**
     * @var \Magento\Framework\DataObjectFactory
     */
    private $dataObjectFactory;



    public function __construct(
        BlockHelper $blockHelper,
        \Magento\Framework\Registry $registry,
        VoteRepository $voteRepository,
        \Magento\Framework\DataObjectFactory $dataObjectFactory
    ) {
        $this->registry = $registry;
        $this->voteRepository = $voteRepository;
        $this->blockHelper = $blockHelper;
        $this->dataObjectFactory = $dataObjectFactory;
    }

    /**
     * @param MagentoForm $subject
     * @param \Magento\Framework\Data\Form $form
     * @return array
     */
    public function beforeSetForm(
        MagentoForm $subject,
        \Magento\Framework\Data\Form $form
    ) {
        $fieldset = $form->getElement('review_details') ?: $form->getElement('add_review_form');
        $review = $this->registry->registry('review_data') ?: $this->dataObjectFactory->create();
        $fieldset->addField(
            'size_fits',
            'select',
            [
                'label' =>__('Size Fits'),
                'required' => false,
                'values' =>     [
                    ['value' => 0, 'label'=> __('---select---')],
                    ['value' => 1, 'label'=> __('Small')],
                    ['value' => 2, 'label'=> __('True to Size')],
                    ['value' => 3, 'label'=> __('Large')],

                ] ,
                'name' => 'size_fits',
                'value' => (int)$review->getData('size_fits')
            ]
        );

        $form->setData('enctype', 'multipart/form-data');
        $imageHtml = trim($this->blockHelper->getReviewImagesHtml($review->getId(), 8575));
        $addImageTitle = __('Customer Images');
        if ($imageHtml) {
            $fieldset->addField(
                'added_images',
                'note',
                [
                    'label'              => __('Customer Images'),
                    'required'           => false,
                    'name'               => 'added_images',
                    'after_element_html' => $imageHtml
                ]
            );
            $addImageTitle = '';
        }

        $fieldset->addField(
            'review_images',
            \Joshine\Review\Data\Form\Element\Image::class,
            [
                'label' => $addImageTitle,
                'name' => 'review_images[]',
                'before_element_html' =>  __('Add new images')
            ]
        );

        return [$form];
    }

    /**
     * @param $review
     * @return \Magento\Framework\Phrase
     */
    private function getReviewHelpfulness($review)
    {
        $vote = $this->voteRepository->getVotesCount($review->getId());
        return __('%1 people found this helpful; %2 found this unhelpful.', $vote['plus'], $vote['minus']);
    }
}
