<?php
namespace Joshine\Banner\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;

class PostActions extends Column
{
    const URL_EDIT='joshine_banner/index/edit';
    const URL_DELETE = 'joshine_banner/index/delete';

    protected $urlBuilder;

    public function __construct(ContextInterface $context, UiComponentFactory $uiComponentFactory, array $components = [], array $data = [],UrlInterface $urlBuilder)
    {
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource)
    {
        // TODO: Change the autogenerated stub
        if (isset($dataSource['data']['items'])){
            foreach ($dataSource['data']['items'] as &$item){
                if (isset($item)){
                    $item[$this->getData('name')] = [
                        'edit'=>[
                            'href' => $this->urlBuilder->getUrl(self::URL_EDIT,['id'=>$item['id']]),
                            'label' => __('Edit')
                        ],
                        'delete'=>[
                            'href' => $this->urlBuilder->getUrl(self::URL_DELETE,['id'=>$item['id']]),
                            'label' => __('Delete'),
                            'confirm' => [
                                'title' => __('Delete'),
                                'message' => __('Are you sure you wan\'t to delete record?')
                            ]
                        ]
                    ];
                }
            }
        }

        return $dataSource;
    }
}