define(
    [
        'jquery',
        'mage/translate',
        'mage/url',
        'magnificPopup'
    ], function ($, $t, url) {
        "use strict";

        $.widget(
            'sparsh.QuickView', {
                options: {
                    baseUrl: '/',
                    popupTitle: $t('Add To Cart'),
                    itemClass: '.products.list .item.product-item, .widget-product-grid .product-item, .add-product-shop-car',
                    btnLabel: $t('Add To Cart'),
                    btnContainer: '.product-item-info',
                    handlerClassName: 'sparsh-quick-view-button',
                    defaultClassName: 'action primary'
                },
                _create: function () {
                    if (!$('body').hasClass('catalog-product-view')) {
                        this._initialButtons(this.options);
                        this._bindPopup(this.options);
                    }
                },
                _initialButtons: function (config) {
                    $(config.itemClass).each(function () {
                        if (!$(this).find('.' + config.handlerClassName).length) {
                            var groupName = $(this).parent().attr('class').replace(' ', '-');
                            var productId = $(this).find('.price-final_price').data('product-id');
                            if (typeof productId !== 'undefined' && productId !== undefined && productId !== null) {
                                var url = config.baseUrl + 'quickview/catalog_product/view/id/' + productId;
                                var btnQuickView = '<div class="sparsh-quick-view-btn-container">';
                                btnQuickView += '<a rel="' + groupName + '" class="' + config.defaultClassName + ' ' + config.handlerClassName + ' sparsh-quick-view-button-pc" href="' + url + '"';
                                btnQuickView += ' title="' + config.popupTitle + '"';
                                btnQuickView += ' >';
                                btnQuickView += '<svg t="1677035083997" class="quick-view-icon-view" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="3700"><path d="M987.52 367.36c-108.16-146.56-266.88-239.36-444.16-239.36-177.28 0-335.36 92.8-444.16 239.36-48 64.64-48 160.64 0 225.28C208 739.2 366.72 832 543.36 832c177.28 0 335.36-92.8 444.16-239.36C1035.52 528 1035.52 432 987.52 367.36zM939.52 539.52C839.04 684.8 694.4 768 542.72 768c-151.68 0-296.32-83.2-396.8-228.48C121.6 505.6 121.6 455.04 145.92 420.48 246.4 275.2 391.04 192 542.72 192c151.68 0 296.32 83.2 396.8 228.48C963.2 455.04 963.2 505.6 939.52 539.52zM544 256C420.48 256 320 356.48 320 480S420.48 704 544 704 768 603.52 768 480 667.52 256 544 256zM544 640C455.68 640 384 568.32 384 480S455.68 320 544 320C632.32 320 704 391.68 704 480S632.32 640 544 640z" p-id="3701" fill="#ffffff"></path></svg><span>' + config.btnLabel + '</span></a>';

                                btnQuickView += '<a rel="' + groupName + '" class="' + config.defaultClassName + ' ' + config.handlerClassName + ' sparsh-quick-view-button-phone " id="sparsh-quick-view-button-phone" href="' + url + '"';
                                btnQuickView += ' title="' + config.popupTitle + '"';
                                btnQuickView += ' >';
                                //btnQuickView += '<svg t="1677047956598" class="quick-view-icon-shop-car" viewBox="0 0 1028 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="5146" ><path d="M332.8 790.528q19.456 0 36.864 7.168t30.208 19.968 20.48 30.208 7.68 36.864-7.68 36.864-20.48 30.208-30.208 20.48-36.864 7.68q-20.48 0-37.888-7.68t-30.208-20.48-20.48-30.208-7.68-36.864 7.68-36.864 20.48-30.208 30.208-19.968 37.888-7.168zM758.784 792.576q19.456 0 37.376 7.168t30.72 19.968 20.48 30.208 7.68 36.864-7.68 36.864-20.48 30.208-30.72 20.48-37.376 7.68-36.864-7.68-30.208-20.48-20.48-30.208-7.68-36.864 7.68-36.864 20.48-30.208 30.208-19.968 36.864-7.168zM930.816 210.944q28.672 0 44.544 7.68t22.528 18.944 6.144 24.064-3.584 22.016-13.312 37.888-22.016 62.976-23.552 68.096-18.944 53.248q-13.312 40.96-33.28 56.832t-49.664 15.872l-35.84 0-65.536 0-86.016 0-96.256 0-253.952 0 14.336 92.16 517.12 0q49.152 0 49.152 41.984 0 20.48-9.728 35.84t-38.4 14.336l-49.152 0-94.208 0-118.784 0-119.808 0-99.328 0-55.296 0q-20.48 0-34.304-9.216t-23.04-24.064-14.848-32.256-8.704-32.768q-1.024-6.144-5.632-29.696t-11.264-58.88-14.848-78.848-16.384-87.552q-19.456-103.424-44.032-230.4l-76.8 0q-15.36 0-25.6-7.68t-16.896-18.432-9.216-23.04-2.56-22.528q0-20.48 13.824-33.792t37.376-12.288l103.424 0q20.48 0 32.768 6.144t19.456 15.36 10.24 18.944 5.12 16.896q2.048 8.192 4.096 23.04t4.096 30.208q3.072 18.432 6.144 38.912l700.416 0zM892.928 302.08l-641.024-2.048 35.84 185.344 535.552 1.024z" p-id="5147" fill="black"></path></svg></a>';
                                btnQuickView += `<svg t="1680586108031" class="quick-view-icon-shop-car" className="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1303" width="64" height="64"><path d="M512 96c140.478 0 253.715 119.82 255.966 267.516L768 368v16h96c35.346 0 64 28.654 64 64v352c0 70.692-57.308 128-128 128H224c-70.692 0-128-57.308-128-128V448c0-35.346 28.654-64 64-64h96v-16c0-149.747 114.103-272 256-272zM256 448h-64c-17.673 0-32 14.327-32 32v320c0 34.993 28.084 63.426 62.942 63.991L224 864h576c34.993 0 63.426-28.084 63.991-62.942L864 800V480c0-17.673-14.327-32-32-32h-64v64c0 17.673-14.327 32-32 32-17.496 0-31.713-14.042-31.996-31.47L704 512v-64H320v64c0 17.673-14.327 32-32 32-17.496 0-31.713-14.042-32-31.47V448z m256 80c17.673 0 32 14.327 32 32v64h64c17.673 0 32 14.327 32 32 0 17.673-14.327 32-32 32h-64v64c0 17.673-14.327 32-32 32-17.673 0-32-14.327-32-32v-64h-64c-17.673 0-32-14.327-32-32 0-17.673 14.327-32 32-32h64v-64c0-17.673 14.327-32 32-32z m0-368c-104.471 0-190.269 90.807-191.974 204.546L320 368v16h384v-16c0-115.35-86.474-208-192-208z" fill="#000000" p-id="1304"></path></svg>`;
                                btnQuickView += '</div>';
                                $(this).find(config.btnContainer).prepend(btnQuickView);
                                $(this).addClass('sparsh-quick-view-item');
                            }
                        }
                    });
                },
                _bindPopup: function (config) {
                    var self = this;
                    $('.' + config.handlerClassName).each(
                        function () {
                            $(this).magnificPopup(
                                {
                                    type: 'ajax',
                                    closeOnContentClick: false,
                                    closeMarkup: '<button title="Close (Esc)" type="button" class="sparsh-mfp-close sparsh-mfp-quick-close"></button>',
                                    callbacks: {
                                        ajaxContentAdded: function () {
                                            $('.sparsh-mfp-content').trigger('contentUpdated');
                                            $('.sparsh-mfp-content').prop('id', 'sparsh-mfp-quickview');
                                            $('#sparsh-mfp-quickview').prepend('<div class="sparsh-mfp-quickview-message"></div>');
                                            if($('#sparsh-mfp-quickview').find('.table-wrapper.grouped').length){
                                                $('.sparsh-mfp-content').addClass('page-product-grouped');
                                            }
                                            if($('#sparsh-mfp-quickview').find('.field.downloads').length){
                                                $('.sparsh-mfp-content').addClass('page-product-downloadable');
                                            }
                                            $('.sparsh-mfp-content').addClass('catalog-product-view');
                                            if(!$('body').hasClass('page-layout-1column')){
                                                $('.sparsh-mfp-content').addClass('page-layout-1column');
                                                if($('.sparsh-mfp-content').hasClass('page-product-downloadable')){
                                                    $('.sparsh-mfp-content').addClass('sparsh-quickview-custom-options');
                                                }
                                            }
                                        }
                                    }
                                }
                            );
                        }
                    );

                    $(document).on(
                        'ajaxComplete', function (event, xhr, settings) {
                            if (settings.type.match(/get/i) && _.isObject(xhr.responseJSON)) {
                                var result = xhr.responseJSON;
                                if (_.isObject(result.cart) && _.isObject(result.messages)) {
                                    if(result.messages){
                                        if($('#sparsh-mfp-quickview').length) {
                                            var btn=$('.sparsh-mfp-quick-close');
                                            btn.click();

                                            var car = $('.showcart');
                                            car.click();
                                        }
                                    }
                                }
                            }
                        }
                    );
                }
            }
        );
        return $.sparsh.QuickView;
    }
);

