<?php
namespace Sparsh\FreeShippingBar\Controller\Adminhtml;

/**
 * Class Entity
 * @package Sparsh\FreeShippingBar\Controller\Adminhtml
 */
abstract class Entity extends \Magento\Backend\App\Action
{
    /**
     * Authorization level of a basic admin session.
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Sparsh_FreeShippingBar::free_shipping_bar_management';

    /**
     * Current free shipping bar entity
     */
    const REGISTRY_KEY_CURRENT_ENTITY = 'current_sparsh_free_shipping_bar_entity';

    /**
     * @var \Magento\Framework\Registry
     */
    protected $coreRegistry;

    /**
     * @var \Sparsh\FreeShippingBar\Model\EntityFactory
     */
    protected $entityFactory;

    /**
     * Entity constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Sparsh\FreeShippingBar\Model\EntityFactory $entityFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Sparsh\FreeShippingBar\Model\EntityFactory $entityFactory
    ) {
        parent::__construct($context);
        $this->coreRegistry = $coreRegistry;
        $this->entityFactory = $entityFactory;
    }

    /**
     * Init action.
     *
     * @return $this
     */
    protected function _initAction()
    {
        $this->_view->loadLayout();
        $this->_setActiveMenu('Magento_Backend::marketing')
            ->_addBreadcrumb(__('Sparsh Free Shipping Bar'), __('Sparsh Free Shipping Bar'));
        return $this;
    }
}
