<?php


namespace Joshine\Category\Model\Category\Attribute\Source;

use function Joshine\Model\Category\Attribute\Source\count;

class Badge extends \Magento\Eav\Model\Entity\Attribute\Source\AbstractSource
{

    protected $_optionsData;

    /**
     * Constructor
     *
     * @param array $options
     */
    public function __construct(array $options = [])
    {
        $this->_optionsData = $options;
    }

    /**
     * getAllOptions
     *
     * @return array
     */
    public function getAllOptions()
    {
        if (!$this->_optionsData) {
            $this->_optionsData = [
                ['value' => '',      'label'  => '----'],
                ['value' => json_encode(['text'=>'HOT!', 'class'=>'ui-menu-icon-3 ui-icon-3']),     'label'  => 'Hot'],
                ['value' => json_encode(['text'=>'NEW!', 'class'=>'ui-menu-icon-1 ui-icon-1']),     'label'  => 'New'],
                ['value' => json_encode(['text'=>'SALE!','class'=>'ui-menu-icon-2 ui-icon-2']),     'label'  => 'Sale'],
            ];
        }
        return $this->_optionsData;
    }
}
