<?php

namespace Joshine\InstagramFeed\Controller\Adminhtml\OAuth;
use Joshine\InstagramFeed\Block\ApiAddress;
use \Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Store\Model\ScopeInterface;

class Redirect extends Action
{
    protected $_publicActions = ['redirect'];

    protected $_apiAddress;
    /**
     * @var ApiAddress
     */
    private $_curlClient;

    /**
     * @var \Magento\Framework\App\Config\Storage\WriterInterface
     */
    private $_configWriter;

    private $_cacheTypeList;

    public function __construct(
        Context $context,
        Curl $curl,
        \Magento\Framework\App\Config\Storage\WriterInterface $configWriter,
        ApiAddress $apiAddress,
        \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList
    )
    {
        $this->_curlClient   = $curl;
        $this->_configWriter  = $configWriter;
        $this->_apiAddress    = $apiAddress;
        $this->_cacheTypeList = $cacheTypeList;
        parent::__construct($context);
    }

    public function getCurlClient()
    {
        return $this->_curlClient;
    }

    public function execute()
    {
        $codeRaw = $this->getRequest()->getParam('code');
        if (!$codeRaw) {
            return "Error Code";
        }
        $code = rtrim($codeRaw, "#_");

        try {
            $oauthRes = $this->getToken($code);

            if (!isset($oauthRes['access_token'])) {
                return;
            }

            $longTokenRaw = $this->getLongToken($oauthRes["access_token"]);
            $longToken    = json_decode($longTokenRaw, true);
            if (!isset($longToken['access_token'])) {
                echo $longTokenRaw;
                return;
            }
            $userId        = $oauthRes['user_id'];
            $longLifeToken = $longToken['access_token'];
            $this->_configWriter->save("joshine_instagram_feed/general/user_id",  $userId);
            $this->_configWriter->save("joshine_instagram_feed/general/access_token",  $longLifeToken);
            $this->_cacheTypeList->cleanType(\Magento\Framework\App\Cache\Type\Config::TYPE_IDENTIFIER);
            echo  "Success!";
            return;
        } catch (\Exception $e) {
            \Magento\Framework\App\ObjectManager::getInstance()
                ->get('Psr\Log\LoggerInterface')->warning($e->getMessage());
        }
        echo  "Something error, try again";
    }

    private function getLongToken($token)
    {
        $url = $this->_apiAddress->getLongTokenUrl()."?grant_type=ig_exchange_token"
        ."&client_secret={$this->_apiAddress->getAppSecret()}"
        ."&access_token={$token}";

        $this->getCurlClient()->get($url);
        $this->getCurlClient()
            ->setOptions([
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_SSL_VERIFYPEER => false
            ]);

        return $this->getCurlClient()->getBody();
    }

    private function getToken($code)
    {
        $request = [
            'code'          => $code,
            'client_secret' => $this->_apiAddress->getAppSecret(),
            'redirect_uri'  => $this->_apiAddress->redirectUri(),
            'grant_type'    => 'authorization_code',
            'client_id'     => $this->_apiAddress->getAppid(),
        ];
        $this->getCurlClient()->post($this->_apiAddress->getTokenUrl(), $request);
        $this->getCurlClient()
            ->setOptions([
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_SSL_VERIFYPEER => false
            ]);

        if ($this->getCurlClient()->getStatus() != 200) {
            ob_clean();
            echo $this->getCurlClient()->getBody();
            return [];
        }
        return json_decode($this->getCurlClient()->getBody(), true);
    }
}