import { BasePaginationData, BaseRespData } from '@/types/api'
import {
  ProductList,
  PodUsOrderListData,
  SearchForm,
  Tab,
  LogListData,
  ProductionClient,
  WarehouseListData,
  LogisticsData,
  ExportParams,
  InterceptStateGroupData,
} from '@/types/api/podUsOrder'
import axios from './axios'
import { PodMakeOrderData } from '@/types/api/podMakeOrder'
export function exportPodUSInfo(data: ExportParams) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderUs/exportPodUsOrder',
    data,
  )
}
// 同步收货地址
export function syncReceiverAddress(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/syncReceiverAddress',
    data,
  )
}
export function refreshAddressApi(idList: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/syncReceiverAddress',
    idList,
  )
}

export function updateAddressApi(data: PodUsOrderListData) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/updateReceiverAddress',
    data,
  )
}
export function getOrderTabData() {
  return axios.get<never, BaseRespData<Tab[]>>(
    '/factory/podJomallOrderUs/findStateGroupList',
  )
}
// 拦截状态数量
export function getgetInterceptStateGroupList() {
  return axios.get<never, BaseRespData<InterceptStateGroupData>>(
    'factory/podJomallOrderUs/findInterceptStateGroupList',
  )
}

export function getOrderList(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<PodUsOrderListData>>(
    '/factory/podJomallOrderUs/list_page',
    {
      ...params,
      currentPage,
      pageSize,
    },
  )
}
export function handleExceptionOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/processExceptionOrders',
    orderIds,
  )
}
export function getCardOrderList(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<ProductList[]>>(
    '/factory/podJomallOrderProductUs/list_page',
    {
      ...params,
      currentPage,
      pageSize,
    },
  )
}
export function confirmOrderApi(
  data: number[],
  productionClient: string,
  type: string,
  logisticsTrialCalculation?: LogisticsData | null,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/confirmOrders',
    {
      ids: data.join(','),
      type,
      logisticsTrialCalculation,
      productionClient,
    },
  )
}
export function getProductionClientApi() {
  return axios.get<never, BaseRespData<ProductionClient[]>>(
    'factory/podJomallOrderUs/getProductionClientList',
  )
}
export function updateExceptionOrderApi(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/updateExceptionOrders',
    {
      orderIds: data,
    },
  )
}
export function changeExceptionOrderApi(
  url: string,
  ids: number[],
  type: string,
  value: string,
) {
  return axios.post<never, BaseRespData<never>>(url, {
    orderIds: ids,
    exceptionType: type,
    exceptionReason: value,
  })
}
export function cancelOrderApi(ids: number[], value: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/cancelOrders',
    {
      orderIds: ids,
      cancelReason: value,
    },
  )
}
export function getOperationLogApi(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/podJomallOrderUsLog/getPodJomallOrderUsLog?id=${id}`,
  )
}
export function getSubOrderBySubOrderNumber(factorySubOrderNumber: string) {
  return axios.get<never, BaseRespData<ProductList>>(
    'factory/podJomallOrderProductUs/getProductUsByFactorySubOrderNumber',
    {
      params: {
        factorySubOrderNumber,
      },
    },
  )
}
export function downloadMaterialApi(id: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductUs/downloadDesignImages',
    id,
  )
}
export function productionQueryApi(id: number, podJomallOrderUsId: number) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderProductUs/completeDelivery',
    {
      id,
      podJomallOrderUsId,
    },
  )
}
export function printProductionOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductUs/printProducePdf',
    orderIds,
  )
}
export function printPrintOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductUs/printPickPdf',
    {
      ids: orderIds.join(','),
    },
  )
}
export function printPickingOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductUs/pickingComplete',
    {
      ids: orderIds.join(','),
    },
  )
}
export function stockOutCheckApi(orderIds: number[]) {
  return axios.get<
    never,
    BaseRespData<
      {
        id: number
        status: boolean
        message?: string
        factoryOrderNumber?: string
      }[]
    >
  >(`factory/podJomallOrderUs/replenishVerify?ids=${orderIds.join(',')}`)
}
export function toBePickingApi(orderIds: number[]) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateStockOutOrderToPicking?ids=${orderIds.join(
      ',',
    )}`,
  )
}
export function getOrderDetailById(id: number) {
  return axios.get<never, BaseRespData<ProductList>>(
    `factory/podJomallOrderProductUs/getProductUsById?id=${id}`,
  )
}
export function getPackingDataApi(
  code: string,
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData>>(
    '/factory/podJomallOrderUs/getPodBoxDetailsBySkuOrNo',
    {
      params: {
        podJomallUsNo: code,
        box,
        factoryNo,
        warehouseId,
      },
    },
  )
}
export function getPodBoxListApi(
  factoryNo: number | string,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData[]>>(
    'factory/podJomallOrderUs/getPodBoxOrderDetails',
    {
      params: { factoryNo, warehouseId },
    },
  )
}

export function submitInspectionApi(
  data: { id: number; version?: number }[],
  boxIndex: number | null,
  warehouseId: number | string,
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/podPrintOrderComplete?box=${boxIndex}&warehouseId=${warehouseId}`,
    {
      orderParamList: data,
    },
  )
}
export function clearBoxApi(
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/delPodBoxOrderDetailsByBox',
    {
      params: { factoryNo, box, warehouseId },
    },
  )
}
export function clearAllBoxApi() {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/delPodBoxOrderDetails',
  )
}
export function updateRemarkApi(id: number, content: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/addRemark',
    { id, content },
  )
}

export function getLogisticsCalculation(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/getLogisticsCalculation',
    { params: { id } },
  )
}
export function loadWarehouseListApi() {
  return axios.get<never, BaseRespData<WarehouseListData[]>>(
    'factoryWarehouseInfo/getAll',
  )
}
export function refreshMaterialApi(data: {
  orderIds?: string
  productIds?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductUs/refreshDesignImages',
    data,
  )
}
// 获取跟踪号
export function getTrackingNumberApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/getTrackingNumber',
    orderIds,
  )
}
// 获取打印面单
export function getfaceSimplexFileApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/getfaceSimplexFile',
    orderIds,
  )
}
// 取消物流订单
export function cancelLogisticsOrderApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/cancelLogisticsOrder',
    orderIds,
  )
}
// 更改物流
export function changeLogisticsApi(params: {
  updateByIdParam: {
    id: string | number
    dataVersion: number
  }
  logisticsTrialCalculation: LogisticsData
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/changeLogistics',
    params,
  )
}
// 创建物流
export function createLogisticsOrderApi(params: {
  updateByIdParam: {
    id: string | number
    dataVersion: number
  }
  logisticsTrialCalculation: LogisticsData
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/createLogisticsOrder',
    params,
  )
}

// 物流面单上传
export function uploadExpressSheet(params: {
  trackingNumber: string
  file: File
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/uploadExpressSheet',
    params,
  )
}
// 更新物流信息确认
export function updateSelfLogistics(params: {
  trackingNumber: string
  expressSheet: string
  processNumber: string
  id?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderUs/updateSelfLogistics',
    params,
  )
}

// 更改物流
export function composingDesignImages(
  data: number[],
  type?: string,
  templateWidth?: number,
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/composingDesignImages?type=${type}&templateWidth=${templateWidth}`,
    data,
  )
}
// 转至待排单
export function updateLogisticsToArrangeApi(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateLogisticsToArrange`,
    {
      params,
    },
  )
}
//创建物流订单
export function createLogisticsOrdersApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/createLogisticsOrders`,
    orderIds,
  )
}

export function applyForReplenishmentApi(
  data: {
    id: number
    productId: number
    factorySubOrderNumber: string | number
    replenishmentNum: string
    podJomallOrderUsStatus: string
    replenishmentReason: string
  }[],
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductUs/applyForReplenishment`,
    data,
  )
}

export function replenishmentSuccessApi(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductUs/replenishmentComplete`,
    data,
  )
}
//确认生产
export function confirmProductApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/confirmProduct`,
    orderIds,
  )
}
//转至锐印
export function confirmProductToRiinApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/confirmProductToRiin`,
    orderIds,
  )
}
export function toOutOfStockApi(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/pickingToStockOut`,
    ids,
  )
}

// 排单完成
export function arrangeFinishApi(params: {
  productIdList: number[]
  templateWidth?: number
  type?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductUs/arrangeFinish`,
    params,
  )
}

// 获取工艺
export function getListCraftApi() {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductUs/listCraft`,
  )
}

// 批量下载 列表
export function batchDownloadApi(currentPage: number, pageSize: number) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podBatchDownload/us/list_page`,
    {
      currentPage,
      pageSize,
    },
  )
}

// 批量下载 下载
export function batchDownloadDownloadApi(params: { id: number; type: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/download`,
    {
      params,
    },
  )
}

// 批量下载 删除
export function batchDownloadDeleteApi(params: { ids?: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/delete`,
    {
      params,
    },
  )
}

// 批量下载 重新排版
export function batchDownloadRecomposingApi(params: {
  id: number
  type?: string
  templateWidth?: number
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/reComposingDesignImages`,
    {
      params,
    },
  )
}
// 生产完成
export function updateToWaitShipmentApi(params: {
  usUpdateParams: Array<{
    id: number | string
    podJomallOrderUsId: number | string
    factorySubOrderNumber: number | string
    version: number | string
  }>
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateToWaitShipment`,
    params,
  )
}

// 拦截状态改变
export function interceptUpdateApi(params: {
  orderIds: (string | number)[]
  interceptStatus: number
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateInterceptStatus`,
    params,
  )
}
// 驳回
export function rejectToApi(params: {
  orderStatus: string
  productList: ProductList[]
  reasonStr: string
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/rejectTo`,
    params,
  )
}

// 状态推送
export function statusPushApi(params: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/statusPush`,
    params,
  )
}

// 转至已完成
export function changeToFinished(ids: string) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateToComplete`,
    { params: { ids } },
  )
}

// 转至已完成
export function updateTrackingNumberAndRegister(
  id: number,
  trackingNumber: string,
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/updateTrackingNumberAndRegister`,
    { id, trackingNumber },
  )
}

// 完成发货
export function completeDeliveryApi(params: {
  orderIdList: (string | number)[]
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/completeDelivery`,
    params,
  )
}
// 物流轨迹
export function get17TrackInfoApi(params: { id: string | number }) {
  return axios.get(`factory/podJomallOrderUs/get17TrackInfo`, { params })
}
// 获取riin 权限
export function getAccountCodeByFactoryIdApi(params: { token: string }) {
  return axios.get(`factory/baseExternalAccount/getAccountCodeByFactoryId`, {
    params,
  })
}

export function getLogisticsWayApi() {
  return axios.get(`logisticsWay/usableAllList`)
}
// 打印拣货单item
export function printPickPdfByBatchNumberApi(params: {
  batchArrangeNumber: string
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderProductUs/printPickPdfByBatchNumber`,
    {
      params,
    },
  )
}
// 打印生产单item
export function printProductionPdfByBatchNumberApi(params: {
  batchArrangeNumber: string
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderProductUs/printProductionPdfByBatchNumber`,
    {
      params,
    },
  )
}

// 待跟踪 注册列表统计接口
export function countTrackRegisterApi() {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/countTrackRegister`,
  )
}

// 获取US标签列表
export function getCustomTagListApi() {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderUs/getCustomTagList`,
  )
}

// 普货拣货
export function printNormalPickPdfApi(ids: string) {
  return axios.get<never, BaseRespData<string>>(
    'factory/podJomallOrderUs/printNormalPickPdf',
    { params: { ids } },
  )
}
