import axios from '@/api/axios.ts'
import { BasePaginationData, BaseRespData } from '@/types/api'

// 新增规则
interface BaseForm {
  id?: number
}
type ParamKey = `param${number}`
type ParamValue = string | number | boolean | null | undefined
type PostData = BaseForm & Record<ParamKey, ParamValue>
export function usArrangeRuleApi(data: PostData) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderUs/usArrangeRule',
    data,
  )
}

// 编辑规则
export function updateRuleByIdApi(data: PostData) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderUsArrangeRule/updateRuleById',
    data,
  )
}

// us规则列表
export function getByFactoryNoApi(data: { factoryNo: number }) {
  return axios.get<never, BaseRespData<never>>(
    '/factory/podJomallOrderUsArrangeRule/getByFactoryNo',
    { params: data },
  )
}
