# SearchForm(待优化)

## SearchForm 属性 (Props)

|       参数        |                      说明                      |             类型              |  默认值   | 必填 |
| :---------------: | :--------------------------------------------: | :---------------------------: | :-------: | :--: |
|      config       |                   表单配置项                   |      ISeachFormConfig[]       |    []     |  ✓   |
|    modelValue     |                  表单数据对象                  |          ISearchForm          |    {}     |  ✕   |
|    labelWidth     |                  表单标签宽度                  |            string             |  number   |  ✕   |
|       size        |                    组件尺寸                    | 'large'\| 'default' \|'small' | 'default' |  ✕   |
| addPermissionName |      新增按钮权限名（目前没有作用待优化）      |       string \|string[]       |    ''     |  ✕   |
|    isSearchBtn    |                是否显示查询按钮                |            boolean            |   true    |  ✕   |
|    isResetBtn     |                是否显示重置按钮                |            boolean            |   true    |  ✕   |
|     isAddBtn      |                是否显示新增按钮                |            boolean            |   true    |  ✕   |
|    isDeleteBtn    |                是否显示删除按钮                |            boolean            |   true    |  ✕   |
|        ...        | 其余属性与 element-plus 文档中 form Props 相同 |              ...              |    ...    | ...  |

- **Form 表格说明**:
- form 属性 (Props) 可自行添加
- 可参考文件 src\views\logistics\logisticsMethod.vue

---

### ISeachFormConfig 配置项

|  属性  |      说明      |          类型           | 默认值 |
| :----: | :------------: | :---------------------: | :----: |
|  type  |    控件类型    |     EComponenetType     |   -    |
|  prop  |   表单字段名   |         string          |   -    |
| label  |    表单标签    |         string          |   -    |
| attrs  |  控件属性配置  | Record<string, unknown> |   -    |
| render | 自定义渲染函数 |       () => VNode       |   -    |

- attrs 中 element-plus 文档中 FormItem API 相同

---

### 控件类型 (EComponenetType)

|     类型值      |    对应组件     |      说明      | 数据类型  |
| :-------------: | :-------------: | :------------: | :-------: |
|   amountInput   |   AmountInput   |   金额输入框   |  string   |
|      input      |     ElInput     |   普通输入框   |  string   |
| dateRangePicker | DateRangePicker | 日期范围选择器 |   array   |
|   datePicker    |   DatePicker    |   日期选择器   |  string   |
|     select      |     Select      |   下拉选择框   | undefined |

- form 表格如需动态渲染则需要传入计算属性 config

```tsx **config 示例**
const config = [
  // 普通输入框
  {
    type: 'input',
    prop: 'orderId',
    label: '订单号',
    attrs: {
      placeholder: '请输入订单号',
      clearable: true
    }
  },

  // 下拉选择框
  {
    type: 'select',
    prop: 'payStatus',
    label: '支付状态',
    attrs: {
      options: [
        { label: '全部', value: '' },
        { label: '已支付', value: 1 },
        { label: '未支付', value: 0 }
      ],
      style: 'width: 180px'
    }
  },

  // 金额输入框
  {
    type: 'amountInput',
    prop: 'amountRange',
    label: '金额区间',
    attrs: {
      min: 0,
      max: 10000,
      precision: 2,
      placeholder: '请输入金额'
    }
  },

  // 日期范围选择
  {
    type: 'dateRangePicker',
    prop: 'createTime',
    label: '创建时间',
    attrs: {
      startPlaceholder: '开始日期',
      endPlaceholder: '结束日期',
      style: 'width: 320px'
    }
  },

  // 自定义渲染
  {
    prop: 'customRender',
    label: '自定义组件',
    render: () => (
      <div class="custom-render">
        <el-switch active-text="开" inactive-text="关" />
        <el-input-number :min="1" :max="10" />
      </div>
    )
  }
]
```

---

## 事件 (Events)

|      事件名       |     说明     |       回调参数       |
| :---------------: | :----------: | :------------------: |
| update:modelValue | 表单数据更新 | 更新后的表单数据对象 |
|      search       | 点击查询按钮 |          无          |
|       reset       | 点击重置按钮 |          无          |
|        add        | 点击新增按钮 |          无          |
|      delete       | 点击删除按钮 |          无          |

---

## 插槽 (Slots)

|     插槽名     |             说明             | 作用域参数 |
| :------------: | :--------------------------: | :--------: |
| header-content |     替换整个表单头部内容     |     -      |
|   ontherBtn    | 在操作按钮区域添加额外的按钮 |     -      |

```vue **插槽示例**
<SearchForm :config="formConfig">
  <template #header-content>
    <div class="custom-header">
      <h3>高级搜索面板</h3>
      <p>使用以下条件进行精确搜索</p>
    </div>
  </template>

  <template #ontherBtn>
    <el-button type="warning" @click="exportData">导出数据</el-button>
  </template>
</SearchForm>
```

---

## 可用方法

|     方法名     |      说明      |   参数   |
| :------------: | :------------: | :------: |
| getSelectEvent | 获取选中行数据 |    无    |
| selectRowEvent |   设置高亮行   | row: any |

- **可用方法说明**: 可自行添加
