export interface Tab {
  status?: string
  statusName?: string
  quantity?: number
}

export interface SearchForm {
  status?: string | null
  factorySubOrderNumber?: string
  factoryOrderNumber?: string
  customizedQuantity?: string
  userMark?: string
  shipmentNumber?: string
  order?: string
  prop?: string
  shopNumber?: string
  shopNumbers?: string[]
  sku?: string
  timeType?: number | null
  startTime?: string | null
  endTime?: string | null
  internalMemo?: string
  productionFileId?: string
  interceptedStatus?: boolean
  platform?: string
}
export interface CardOrderData {
  id: number
  moreable: boolean
  thirdOrderNumber: string
  factoryOrderNumber: string
  factoryOnlineId: number | null
  replenishmentNum: number | null
  factoryNo: number | null
  factoryCode: string | null
  status: string | number
  weight: number | null
  outCurrencyCode: string | null
  factoryProductAmount: number | null
  thirdProductAmount: number | null
  productAmount: number | null
  carriageAmount: number | null
  totalAmount: number | null
  productNum: number | null
  trackStatus: string | null
  finishTime: string | null
  paymentTime: string | null
  startStockingTime: string | null
  lanshouName: string | null
  lanshouPhone: string | null
  lanshouRegion: string | null
  lanshouAddress: string | null
  lanshouPost: string | null
  manuscriptUrl: string | null
  manuscriptStatus: number | null
  createTime: string | undefined
  updateTime: string | undefined
  remark: string | null
  userMark: string | null
  namespace: string | undefined
  productList: PodProductList[]
  internalMemoList: string | null
  [propName: string]: string | number | boolean | undefined | unknown
}
export interface cardImages {
  ename?: string | null
  cname?: string | null
  image: string
}
export interface imageAryInter {
  sort: number
  title?: string | null
  url: string
}
export interface PodProductList {
  id: number
  podOrderId?: number
  thirdSubOrderNumber?: string
  factorySubOrderNumber?: string
  replenishmentNum?: number | null
  factoryOrderNumber?: string | undefined
  shopNumber?: string
  supplierItemNo?: string | null
  baseSku?: string
  productName?: string
  variantSku?: string
  variantImage?: string
  imageAry?: string | imageAryInter[] | undefined
  images?: cardImages[] | undefined
  designImages?: string | undefined
  process?: string | undefined
  podProcessName?: string | undefined
  productionFileId?: string | undefined
  customizedQuantity?: number
  num?: number | string
  shipmentNu?: number
  costPrice?: number
  price?: number
  processPrice?: number
  weight?: number | undefined
  version?: number | undefined
  remark?: string | undefined
  createTime?: string
  updateTime?: string
  [propName: string]: string | number | boolean | undefined | unknown
}
export interface ImageItemInter {
  url: string
  title?: string | null
  sort: number
  id?: number | string | null
}

export type ImgList = ImageItemInter[][]

export interface PodOrderRes extends PodProductList {
  expectDeliveryTime?: string | null
  thirdOrderNumber?: string | null
  startStockingTime?: string | null
  userMark?: string | null
  color?: string | null
  size?: string | null
  note?: Array<{ prop: string | number; value: string | number }>
  imgList: ImgList
}

export interface SearchOrderRes extends PodProductList {
  expectDeliveryTime?: string | null
  thirdOrderNumber?: string | null
  startStockingTime?: string | null
  userMark?: string | null
  color?: string | null
  size?: string | null
  note?: Array<{ prop: string | number; value: string | number }>
  imgList: {
    url:string
    title?: string
  }[]
}
export interface ShipmentOrderRes {
  factoryOrderNumber?: string
  thirdSubOrderNumber?: string
  sendOutQuantity?: number
  version?: number
  namespace?: string
}
export interface PodDeliveryNoteSearchForm {
  startTime?: string
  endTime?: string
  shipmentNumber?: string
  factoryOrderNumber?: string
  factorySubOrderNumber?: string
  shippingWay?: number
  logisticsTracking?: string
  lanshouName?: string
  sku?: string
  userMark?: string
}
export interface DeliveryNoteData {
  id: number
  factoryOrderNumber?: string
  factoryNo?: number
  shipmentNumber?: string
  shipmentUid?: string
  shippingWay?: number
  carriageAmount?: string
  carriageName?: string
  logisticsTracking?: string
  shippingStatus?: string
  lanshouName?: string
  lanshouPhone?: string
  lanshouRegion?: string
  lanshouAddress?: string
  lanshouPost?: string
  updateTime?: string
  createTime?: string
  shipmentDetails?: ShipmentDetail[]
}

export interface ShipmentDetail {
  id: number
  shipmentId?: number
  podOrderId?: number
  podOrderNumber?: string
  subOrderNumber?: string
  baseSku?: string
  variantSku?: string
  variantImage?: string
  shipmentNum?: number
  updateTime?: string
  createTime?: string
}
export interface LogListData {
  id: number
  bizId?: number
  userId?: number
  employeeName?: string
  description?: string
  createTime?: string
}
export interface LogListData {
  id: number
  bizId?: number
  userId?: number
  employeeName?: string
  description?: string
  createTime?: string
}
