import { defineComponent, ref } from 'vue'
import { ElDialog } from 'element-plus'

export default defineComponent({
  name: 'CustomizeForm',
  props: {
    modelValue: {
      type: Boolean,
      default: false,
    },

    title: {
      type: String,
      default: '',
    },
    dialogWidth: {
      type: String,
      default: '600px',
    },
  },
  emits: ['update:modelValue', 'close'],
  setup(props, { emit, attrs, slots }) {
    const formRef = ref<InstanceType<typeof ElDialog> | null>(null)
    const isShow = ref(false)
    watch(
      () => props.modelValue,
      (val) => {
        isShow.value = val
      },
      { immediate: true },
    )

    return () => {
      return (
        <ElDialog
          ref={formRef}
          v-model={isShow.value}
          title={props.title}
          width={props.dialogWidth}
          onClose={() => {
            emit('close')
          }}
          destroy-on-close={true}
          close-on-click-modal={false}
          {...attrs}
        >
          <div class="dialog-form">
            {slots.default?.()}
            {slots.footer?.()}
          </div>
        </ElDialog>
      )
    }
  },
})
