import axios from './axios'
import { BasePaginationData, BaseRespData } from '@/types/api'
import { SearchForm, OutOfStockItem } from '@/types/api/outOfStockStatistics'
export function getOutOfStockStatisticsListApi(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<OutOfStockItem>>(
    'stockOutStatistics/getStockOutStatistics',
    { ...data, currentPage, pageSize },
  )
}

export function exportOutOfStockStatisticsListApi(data: {
  exportAll: boolean
  indexes?: number[]
}) {
  return axios.post<never, BaseRespData<never>>(
    'stockOutStatistics/exportStockOutStatistics',
    data,
  )
}
