/*
 * @Author: Try
 * @Date: 2023-10-17 18:25:26
 * @LastEditTime: 2024-06-04 14:02:19
 * @LastEditors: Seven
 * @FilePath: \shulong_tenant_pc\src\components\SearchForm\type\index.ts
 * @Description: 头部注释配置模板
 */
export interface ISearchForm {
  [key: string]: any
}

export interface IOptions {
  [key: string]: any
}

export enum EComponenetType {
  amountInput = 'amountInput', // 金额输入框
  input = 'input', // 普通输入框
  dateRangePicker = 'dateRangePicker', // 时间范围选择器
  datePicker = 'datePicker', // 单个日期选择器
  select = 'select', // 普通下拉选择框
}

// EComponenetType 枚举转联合
export type TComponenetType = `${EComponenetType}`

export interface IAttrs {
  options?: IOptions
  hasAllOptions?: boolean // 使用全部选项
  value?: string
  label?: string
  placeholder?: string
  [key: string]: any
}

export interface ISlots{
  formItemSlot?: boolean
}

export interface ISeachFormConfig {
  prop: string
  type?: EComponenetType | TComponenetType
  label?: string
  defaultValue?: string
  attrs?: IAttrs
  labelWidth?: number | string
  slot?: ISlots
  [key: string]: any
}

export interface IKeyBoolean {
  [key: string]: boolean
}

export enum EDataType {
  array = 'array',
  string = 'string',
  number = 'number',
  boolean = 'boolean',
  object = 'object',
  undefined = 'undefined',
}

// 下载导入模板的配置
export interface IDownloadXlsConfig {
  filename: string
  url: string
}
