export interface BaseRespData<D> {
  code: number
  message?: string
  data: D
  total?: number
}

export interface PaginationData<D> {
  page?: PaginationData<D>
  craftPrice?: string
  costPrice?: string
  total: number
  size: number
  current: number
  records: D[]
  data?: D[]
}
export interface Statistics<D> {
  sumNotPassNum: number
  sumPassNum: number
  sumShipmentNum: number
  sumTotalPrice: number
  page: {
    total: number
    size: number
    current: number
    records: D[]
  }
}

export type BasePaginationData<D> = BaseRespData<PaginationData<D>>

export type StatisticsData<D> = BaseRespData<Statistics<D>>
export interface baseRes {
  code: number
  msg: string
}

