export interface SearchForm {
  warehouseApplyNo?: string
  manageNo?: string
  warehouseId?: string | number[]
  warehouseSku?: string | number[]
  warehouseSkuName?: string
  currentPage: number
  pageSize: number
  storeStatus?: string
}
export interface TreeData {
  id?: number
  code?: string
  name?: string
  countQuantity?: number
  children?: TreeData[]
  leaf?: boolean
}
export interface TableData {
  id: number
  factoryId?: number
  factoryCode?: string
  manageId?: number
  manageNo?: string
  warehouseApplyNo: string
  warehouseId?: number
  warehouseName?: string
  skuTotal?: number
  total?: number
  buyStored?: number
  rejectsAmount?: number
  storeStatus: string
  expectDeliveryTime?: string
  createUserId?: number
  createUserName?: string
  createTime?: string
  updateTime?: string
  dataVersion?: number
}

export interface StockingApplyOrderDetailList {
  id: number
  manageId?: number
  warehouseApplyId?: number
  warehouseApplyNo?: string
  warehouseSku?: string
  productNo?: string
  warehouseSkuName?: string
  warehouseSkuImage?: string
  shipmentQuantity?: number
  buyStored?: number | string
  rejectsAmount?: number | string
  price?: number
  createTime?: string
  updateTime?: string
  locationId?: number
  locationCode?: string | undefined
  finallyShipmentQuantity?: number
  storedPending?: number
}

export interface RelatedDocumentList {
  id: number
  dataVersion?: number
  createTime?: string
  updateTime?: string
  factoryId?: number
  factoryCode?: string
  warehouseId?: number
  warehouseName?: string
  inNo?: string
  skuAmount?: number
  total?: number
  totalPrice?: number
  billStatus?: string
  billStatusTxt?: string
  makerName?: string
  makerUserId?: number
  makeTime?: string
  checkerUserId?: number
  checkerName?: string
  source?: string
  sourceOn?: string
}
export interface StockingApplyOrderDetailData {
  id: number
  warehouseApplyNo?: string
  warehouseName?: string
  warehouseId?: number
  checkerUserId?: number
  remark?: string
  checkerName?: string
  detailsList: StockingApplyOrderDetailList[]
}

export interface LocationDataBySkuData {
  id: number
  factoryId?: number
  warehouseId?: number
  warehouseName?: string
  locationId?: number
  locationCode?: string
  warehouseSku?: string
  customSku?: string
  skuName?: string
  createTime?: string
  updateTime?: string
  productItem?: unknown
  usableInventory?: number
  image?: string
  price?: number
  currencyCode?: string
  currencyName?: string
  sumOccupyInventory?: number
}
