export interface TreeData {
  name: string
  code: string
  children?: TreeData[]
  countQuantity?: number
  id?: number
}
export interface SearchForm {
  currentPage: number
  endDate?: string
  pageSize: number
  shippingStatusList?: string[]
  startDate?: string
  status?: string
  stockingUpManageNo?: string
  stockingUpUserId?: string[]
  supplierId?: string[]
  warehouseId?: string | number[]
  warehouseSku?: string | number[]
  warehouseSkuName?: string
  remark?: string
}
export interface TableData {
  id: number
  factoryId?: number
  factoryCode?: string
  stockingUpManageNo?: string
  currencyCode?: string
  skuTotal?: number
  total?: number
  totalPrice?: number
  buyStored?: number
  storedPrice?: number
  buyUnstored?: number
  unstoragePrice?: number
  shipmentQuantity?: number
  rejectsAmount?: number
  shipmentFreight?: number
  expectDeliveryTime?: string
  status?: string
  supplierId?: number
  supplierName?: string
  warehouseId?: number
  warehouseName?: string
  stockingUpUserId?: number
  stockingUpUserName?: string
  createUserId?: number
  createUserName?: string
  createTime?: string
  updateTime?: string
  remark?: string
  dataVersion?: number
  shippingStatus?: number
  delayDays?: number
  lastDeliveryTime?: string
  completeTime?: string
  auditName?: string
  auditTime?: string
}
export interface StockProduct {
  skuImage?: string
  productName?: string
  styleNumber?: string
  warehouseSku?: string
  stockQuantity?: number
  stockUnitPrice?: number
  stockAmount?: number
  unshippedQuantity?: number
  shippedQuantity?: number
  inWarehouseQuantity?: number
  defectiveQuantity?: number
}
export interface AddStockingOrderForm {
  id?: number | string
  stockingUpManageNo?: string
  supplierId?: number
  supplierName?: string
  stockingUpUserId?: number
  stockingUpUserName?: string
  warehouseId?: number
  warehouseName?: string
  expectDeliveryTime?: string
  totalPrice?: string
  currencyCode?: string
  currencyName?: string
  remark?: string
  status?: number
  submission?: boolean
  detailsList?: StockingOrderProduct[]
  examineStatus?: number // 审核状态：1通过，0驳回
  rejectReason?: string // 驳回原因
}

export interface StockingOrderProduct {
  productNo?: string
  warehouseSkuId?: number
  warehouseSku?: string
  warehouseSkuName?: string
  warehouseSkuImage?: string
  buyAmount?: number | string
  price?: number | string
  currencyCode?: string
  currencyName?: string
  totalPrice?: number | string
  shipmentQuantity?: number | string
  buyStored?: number
  // 供应商发货相关字段
  remainingQuantity?: number // 剩余待发货数量
  currentShipQuantity?: number | string // 本次发货数量
}

export interface RelatedDocumentList {
  id: number
  factoryId?: number
  factoryCode?: string
  manageId?: number
  manageNo?: string
  warehouseApplyNo?: string
  warehouseId?: number
  warehouseName?: string
  skuTotal?: number
  total?: number
  buyStored?: number
  rejectsAmount?: number
  storeStatus?: string
  expectDeliveryTime?: string
  createUserId?: number
  createUserName?: string
  createTime?: string
  updateTime?: string
  dataVersion?: number
}
export interface InternalMemoList {
  id: number
  outId?: number
  operatorEmployeeName?: string
  operatorTime?: string
  content?: string
  remark?: string
  type?: number
}
export interface LogListData {
  id: number
  manageId?: number
  userId?: number
  userName?: string
  description?: string
  updateTime?: string
}
