import axios from '@/api/axios'
import { BasePaginationData, BaseRespData } from '@/types/api'
import { LogListData } from '@/types/api/supply/stockingOrder'
import {
  SearchForm,
  TableData,
  TreeData,
  StockingApplyOrderDetailList,
  RelatedDocumentList,
  StockingApplyOrderDetailData,
  LocationDataBySkuData,
} from '@/types/api/warehouse/stockingApplyOrder'

export function getStockingApplyOrderListApi(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<TableData>>(
    'factory/supply/stockingUpWarehouseApply/list_page',
    { ...data, currentPage, pageSize },
  )
}

export function getStockingApplyOrderTreeApi() {
  return axios.get<never, BaseRespData<TreeData[]>>(
    'factory/supply/stockingUpWarehouseApply/getStatusTree',
  )
}

export function getStockingApplyOrderDetailListByIdApi(id: number) {
  return axios.get<never, BaseRespData<StockingApplyOrderDetailList[]>>(
    `factory/supply/stockingUpWarehouseApply/getWarehouseApplyList?id=${id}`,
  )
}

export function getStockingApplyOrderRelatedDocumentListByIdApi(
  warehouseApplyNo: string,
) {
  return axios.get<never, BaseRespData<RelatedDocumentList[]>>(
    `factory/supply/stockingUpWarehouseApply/getWarehouseInList?warehouseApplyNo=${warehouseApplyNo}`,
  )
}

export function getStockingApplyOrderLogListByIdApi(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/supply/stockingUpWarehouseApplyLog/getWarehouseApplyLog?warehouseApplyId=${id}`,
  )
}

export function warehouseReceiptApi(id: number) {
  return axios.get<never, BaseRespData<void>>(
    `factory/supply/stockingUpWarehouseApply/receiving?id=${id}`,
  )
}

export function submitWarehousingApi(data: StockingApplyOrderDetailData) {
  return axios.post<never, BaseRespData<void>>(
    'factory/supply/stockingUpWarehouseApply/submitInventory',
    data,
  )
}

export function getStockingApplyOrderDetailById(id: number) {
  return axios.get<never, BaseRespData<StockingApplyOrderDetailData>>(
    `factory/supply/stockingUpWarehouseApply/get?id=${id}`,
  )
}

export function getLocationListApi(sku: string, warehouseId: string | number) {
  return axios.post<never, BaseRespData<LocationDataBySkuData[]>>(
    'factoryWarehouseInventory/getBySkuAndWarehouseId',
    {
      sku,
      warehouseId,
    },
  )
}
