import { BasePaginationData, BaseRespData } from '@/types/api'
import axios from './../axios'
import {
  IListPage,
  IsupplierType,
} from '@/views/supply/supplierManagement/types/index'

//供应商分页查询
export function getSupplierListApi(params: IListPage) {
  return axios.get<never, BasePaginationData<never>>(
    '/factory/supplier/list_page',
    { params },
  )
}

// 删除供应商
export function deleteSupplierApi(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>('/factory/supplier/delete', {
    params,
  })
}

// 编辑回显接口
export function getSupplierDetailApi(id: string | number) {
  return axios.get<never, BaseRespData<never>>('factory/supplier/get', {
    params: { id },
  })
}

// 根据分类id获取属性信息
export function getPropertyByCateIdApi(cateId: string | number) {
  return axios.get<never, BaseRespData<never>>(
    '/factory/supplier/getPropertyByCateId',
    {
      params: { cateId },
    },
  )
}
// 根据spu获取商品信息
export function getProductInfoBySpuApi(spu: string | number) {
  return axios.get<never, BaseRespData<never>>(
    '/factory/supplier/getProductInfoBySpu',
    {
      params: { spu },
    },
  )
}

//新增
export function addSupplierApi(params: IsupplierType) {
  return axios.post<never, BaseRespData<never>>('/factory/supplier/add', params)
}
//修改
export function updateSupplierApi(params: IsupplierType) {
  return axios.post<never, BaseRespData<never>>(
    '/factory/supplier/update',
    params,
  )
}
