import axios from '../axios'
import { BasePaginationData, BaseRespData } from '@/types/api'
import {
  SearchForm,
  TableData,
  TreeData,
  AddStockingOrderForm,
  StockingOrderProduct,
  InternalMemoList,
  RelatedDocumentList,
  LogListData,
} from '@/types/api/supply/stockingOrder'

export function getStockingOrderListApi(
  data: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<TableData>>(
    'factory/supply/stockingUpManage/list_page',
    { ...data, currentPage, pageSize },
  )
}

export function getStockingOrderStatusTreeApi() {
  return axios.get<never, BaseRespData<TreeData[]>>(
    'factory/supply/stockingUpManage/getStatusTree',
  )
}

// 新增备货单
export function addStockingOrderApi(url: string, data: AddStockingOrderForm) {
  return axios.post<never, BaseRespData<never>>(url, data)
}

// 根据父SKU查询商品信息
export function getProductBySkuApi(spu: string, supplierId: number) {
  return axios.get<never, BaseRespData<StockingOrderProduct[]>>(
    'factory/supply/stockingUpManage/getCustomProductItem',
    {
      params: { productItemSku: spu, supplierId },
    },
  )
}

export function getStockingOrderDetailByIdApi(id: number) {
  return axios.get<never, BaseRespData<AddStockingOrderForm>>(
    `factory/supply/stockingUpManage/get?id=${id}`,
  )
}

export function getStockingOrderDetailListByIdApi(id: number) {
  return axios.get<never, BaseRespData<StockingOrderProduct[]>>(
    `factory/supply/stockingUpManage/getManageDetailsList?id=${id}`,
  )
}

export function getStockingOrderRelatedDocumentListByIdApi(id: number) {
  return axios.get<never, BaseRespData<RelatedDocumentList[]>>(
    `factory/supply/stockingUpManage/getWarehouseApplyList?id=${id}`,
  )
}

export function getStockingOrderInternalMemoListByIdApi(id: number) {
  return axios.get<never, BaseRespData<InternalMemoList[]>>(
    `factory/supply/stockingUpManage/getInternalMemoList?id=${id}`,
  )
}

export function getStockingOrderLogListByIdApi(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/supply/stockingUpManageLog/getStockingUpManageLog?manageId=${id}`,
  )
}

export function submitStockingOrderAuditApi(ids: string) {
  return axios.get<never, BaseRespData<void>>(
    'factory/supply/stockingUpManage/submission',
    {
      params: { ids },
    },
  )
}

export function rejectedStockingOrderApi(params: {
  id: number | string
  turnDownReason: string
}) {
  return axios.get<never, BaseRespData<void>>(
    'factory/supply/stockingUpManage/rejected',
    {
      params,
    },
  )
}

export function supplierDispatchApi(data: {
  manageId: number | string
  manageNo: string
  warehouseId: number | string
  warehouseName: string
  expectDeliveryTime: string
  currencyCode: string
  detailsList: StockingOrderProduct[]
}) {
  return axios.post<never, BaseRespData<void>>(
    'factory/supply/stockingUpWarehouseApply/add',
    data,
  )
}

export function stockingCompleteApi(id: number) {
  return axios.get<never, BaseRespData<void>>(
    `factory/supply/stockingUpManage/delivery?id=${id}`,
  )
}

export function deleteStockingOrderApi(id: string | number) {
  return axios.get<never, BaseRespData<void>>(
    `factory/supply/stockingUpManage/delete`,
    {
      params: { id },
    },
  )
}

export function cancelStockingOrderApi(
  id: string | number,
  cancelReason: string,
) {
  return axios.get<never, BaseRespData<void>>(
    `factory/supply/stockingUpManage/cancel`,
    {
      params: { id, cancelReason },
    },
  )
}

export function addStockingOrderInternalTagApi(memo: string, idList: number[]) {
  return axios.post<never, BaseRespData<void>>(
    `factory/supply/stockingUpManage/batchAddInternalMemo`,
    {
      content: memo,
      idList,
    },
  )
}
