import { BaseRespData } from '@/types/api'
import axios from './axios'
import { LogisticsData } from '@/types/api/order'
import { LogisticBill } from '@/types/api/podMakeOrder'

import { userData } from '@/types/api/user'
import { VersionImageList } from '@/types/api/typesetting'
import { SupplierItem, WarehouseListData } from '@/types'
import { loactionData } from './warehouse'

// 获取物流公司
export function getLogisticsCompanyList() {
  return axios.get<never, BaseRespData<LogisticsData[]>>(
    'factory/customJomallOrder/getLogisticsList',
  )
}
// 获取客户
export function getUserMarkList() {
  return axios.get<never, BaseRespData<string[]>>('dbDiyUser/getUserMarkList')
}

// 获取用户
export function getUserListApi() {
  return axios.get<never, BaseRespData<userData[]>>('factory/factoryUser/list')
}

// 上传图片文件
export function uploadImageApi(data: FormData) {
  return axios.post<never, BaseRespData<never> & VersionImageList>(
    'upload/ossUpload',
    data,
  )
}
export function uploadFileApi(data: FormData) {
  return axios.post<never, BaseRespData<VersionImageList>>(
    'supply/supplyTypesettingInfo/uploadManuscript',
    data,
  )
}

// 打印物流面单 US
export function getLogisticUSApi(content: string) {
  return axios.get<never, BaseRespData<LogisticBill>>(
    `factory/podJomallOrderUs/getOrderByFactorySubOrderNumber?factorySubOrderNumber=${content}`,
  )
}

// 打印物流面单 CN
export function getLogisticCNApi(content: string) {
  return axios.get<never, BaseRespData<LogisticBill>>(
    `factory/podJomallOrder/getOrderByThirdSubOrderNumber?thirdSubOrderNumber=${content}`,
  )
}
// 获取仓库列表
export function loadWarehouseListApi() {
  return axios.get<never, BaseRespData<WarehouseListData[]>>(
    'factoryWarehouseInfo/getAll',
  )
}

// 获取用户列表
export function getEmployeeListApi() {
  return axios.get<never, BaseRespData<userData[]>>(`/factory/factoryUser/list`)
}

// 获取供应商列表
export function getSupplierListApi() {
  return axios.get<never, BaseRespData<SupplierItem[]>>(
    `/factory/supplier/list`,
  )
}

// 获取币种接口
export function getBaseCurrencyInfoApi() {
  return axios.get<never, BaseRespData<never>>(
    'factory/supplier/getBaseCurrencyInfo',
  )
}

// 获取库位List
export function LocationInfoGetAll(wareHouseId?: string | number) {
  return axios.get<never, BaseRespData<loactionData[]>>(
    '/factoryWarehouseLocation/getByWareHouse',
    {
      params: { wareHouseId },
    },
  )
}
