import { createApp } from 'vue'
import App from './App.vue'

import router from './router'
import store from './store'
import './styles/index.scss'

import VxeUITable from 'vxe-table'
import 'vxe-table/lib/style.css'
import { isPermissionBtn } from '@/utils/index'

// 确保在渲染用户提供的HTML内容时，不会执行任何潜在的恶意脚本，从而提高应用的安全性
import vueDomPurifyHTMLPlugin from 'vue-dompurify-html'

const app = createApp(App)

app
  .use(vueDomPurifyHTMLPlugin)
  .use(router)
  .use(store)
  .use(VxeUITable)
  .mount('#app')

app.config.globalProperties.$isPermissionBtn = isPermissionBtn
