import axios from './axios'
import { BaseRespData } from '@/types/api'
import { statisticData, trendType } from '@/types/api/statistic'

//1、核心数据看板
export function getStatisticData() {
  return axios.get<never, BaseRespData<statisticData>>(
    'factory/overview/statistic',
  )
}
//2、趋势图（订单趋势+24/48发货率图+超时发货率图）
export function trendApi(params: {
  timeUnit: string | number
  trendType: string
}) {
  return axios.post<never, BaseRespData<trendType[]>>(
    '/factory/overview/trend',
    params,
  )
}
