import { BasePaginationData, BaseRespData } from '@/types/api'
import {
  ProductList,
  PodCnOrderListData,
  SearchForm,
  Tab,
  LogListData,
  WarehouseListData,
  LogisticsData,
  ExportParams,
  IconfirmSubmit,
  CustomDeclarationInfoForm,
} from '@/types/api/podCnOrder'
import {
  InterceptStateGroupData,
  ProductionClient,
} from '@/types/api/podUsOrder'
import axios from './axios'
import { PodMakeOrderData, OrderData } from '@/types/api/podMakeOrder'
import { PrintData } from '@/types/api/podOrder.ts'
export function exportPodCnInfo(data: ExportParams) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderCn/exportPodCnOrder',
    data,
  )
}
// 拦截状态数量
export function getgetInterceptStateGroupList() {
  return axios.get<never, BaseRespData<InterceptStateGroupData>>(
    'factory/podJomallOrderCn/findInterceptStateGroupList',
  )
}

// 同步收货地址
export function syncReceiverAddress(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/syncReceiverAddress',
    data,
  )
}

export function getEmployeeListApi() {
  return axios.get(`/factory/factoryUser/list`)
}

// 播种墙配货 扫码放入箱子
export function getPackingCnDataApi(
  code: string,
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData>>(
    '/factory/podJomallOrderCn/getPodBoxDetailsBySkuOrNo',
    {
      params: {
        podJomallCnNo: code,
        box,
        factoryNo,
        warehouseId,
      },
    },
  )
}
export function getSingleQueryApi(
  code: string,
  factoryNo: number,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<OrderData>>(
    '/factory/podJomallOrderCn/getPodDetailsBySkuOrNo',
    {
      params: {
        podJomallCnNo: code,
        factoryNo,
        warehouseId,
      },
    },
  )
}
interface LabelFile {
  filePath?: string // 文件地址
  fileData?: string // base64 文件流（二选一）
}
export function getPrintLogisticLabelApi(id?: number) {
  return axios.get<never, BaseRespData<LabelFile>>(
    `factory/podJomallOrderCn/printLogisticLabel?id=${id}`,
  )
}
// 超级播种墙配货 扫码放入箱子
export function getSuperPackingCnDataApi(
  code: string,
  factoryNo: number,
  box: number | null,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData>>(
    'super/factory/podJomallOrderCn/getPodBoxDetailsBySkuOrNo',
    {
      params: {
        podJomallCnNo: code,
        box,
        factoryNo,
      },
    },
  )
}

export function refreshAddressApi(idList: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/syncReceiverAddress',
    idList,
  )
}

export function updateAddressApi(data: PodCnOrderListData) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/updateReceiverAddress',
    data,
  )
}
export function getOrderTabData() {
  return axios.get<never, BaseRespData<Tab[]>>(
    '/factory/podJomallOrderCn/findStateGroupList',
  )
}
export function getOrderList(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
  orderTracking?: boolean,
) {
  return axios.post<never, BasePaginationData<PodCnOrderListData[]>>(
    '/factory/podJomallOrderCn/list_page',
    {
      ...params,
      currentPage,
      pageSize,
      orderTracking,
    },
  )
}
export function getCardOrderList(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BasePaginationData<ProductList[]>>(
    '/factory/podJomallOrderProductCn/list_page',
    {
      ...params,
      currentPage,
      pageSize,
    },
  )
}

export function batchCheckPrintPodCn(ids: string) {
  return axios.get<never, BaseRespData<PrintData[]>>(
    `/factory/podJomallOrderCn/batchCheckPrintPodCn?ids=${ids}`,
  )
}

export function batchCheckPrintPodUs(ids: string) {
  return axios.get<never, BaseRespData<PrintData[]>>(
    `/factory/podJomallOrderUs/batchCheckPrintPodUs?ids=${ids}`,
  )
}

export function confirmOrderApi(
  data: number[],
  productionClient: string,
  type: string,
  logisticsTrialCalculation?: LogisticsData | null,
) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/confirmOrders',
    {
      ids: data.join(','),
      type,
      logisticsTrialCalculation,
      productionClient,
    },
  )
}
export function getProductionClientApi() {
  return axios.get<never, BaseRespData<ProductionClient[]>>(
    'factory/podJomallOrderCn/getProductionClientList',
  )
}
export function updateExceptionOrderApi(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/updateExceptionOrders',
    {
      orderIds: data,
    },
  )
}
export function changeExceptionOrderApi(
  url: string,
  ids: number[],
  type: string,
  value: string,
) {
  return axios.post<never, BaseRespData<never>>(url, {
    orderIds: ids,
    exceptionType: type,
    exceptionReason: value,
  })
}
export function cancelOrderApi(ids: number[], value: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/cancelOrders',
    {
      orderIds: ids,
      cancelReason: value,
    },
  )
}
export function getOperationLogApi(id: number) {
  return axios.get<never, BaseRespData<LogListData[]>>(
    `factory/podJomallOrderCnLog/getPodJomallOrderCnLog?id=${id}`,
  )
}
export function getSubOrderBySubOrderNumber(factorySubOrderNumber: string) {
  return axios.get<never, BaseRespData<ProductList>>(
    'factory/podJomallOrderProductCn/getProductCnByFactorySubOrderNumber',
    {
      params: {
        factorySubOrderNumber,
      },
    },
  )
}
export function downloadMaterialApi(id: number[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductCn/downloadDesignImages',
    id,
  )
}
export function productionQueryApi(id: number, podJomallOrderCnId: number) {
  return axios.post<never, BasePaginationData<never>>(
    'factory/podJomallOrderProductCn/completeDelivery',
    {
      id,
      podJomallOrderCnId,
    },
  )
}
export function printProductionOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductCn/printProducePdf',
    orderIds,
  )
}
export function printPrintOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductCn/printPickPdf',
    {
      ids: orderIds.join(','),
    },
  )
}
export function printPickingOrderApi(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductCn/pickingComplete',
    {
      ids: orderIds.join(','),
    },
  )
}
export function stockOutCheckApi(orderIds: number[]) {
  return axios.get<
    never,
    BaseRespData<
      {
        id: number
        status: boolean
        message?: string
        factoryOrderNumber?: string
      }[]
    >
  >(`factory/podJomallOrderCn/replenishVerify?ids=${orderIds.join(',')}`)
}
export function toBePickingApi(orderIds: number[]) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/updateStockOutOrderToPicking?ids=${orderIds.join(
      ',',
    )}`,
  )
}
export function getOrderDetailById(id: number) {
  return axios.get<never, BaseRespData<ProductList>>(
    `factory/podJomallOrderProductCn/getProductCnById?id=${id}`,
  )
}
export function getPackingDataApi(
  code: string,
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData>>(
    '/factory/podJomallOrderCn/getPodBoxDetailsBySkuOrNo',
    {
      params: {
        podJomallCnNo: code,
        box,
        factoryNo,
        warehouseId,
      },
    },
  )
}
// 播种墙配货 获取pod订单拣货箱子详情
export function getPodBoxListApi(
  factoryNo: number | string,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<PodMakeOrderData[]>>(
    'factory/podJomallOrderCn/getPodBoxOrderDetails',
    {
      params: { factoryNo, warehouseId },
    },
  )
}

// 超级播种墙配货 获取pod订单拣货箱子详情
export function getSuperPodBoxListApi(factoryNo: number | string) {
  return axios.get<never, BaseRespData<PodMakeOrderData[]>>(
    'super/factory/podJomallOrderCn/getPodBoxOrderDetails',
    { params: { factoryNo } },
  )
}

// 超级播种墙配货 获取pod订单拣货箱子详情
export function printNormalPdf(ids: string) {
  return axios.get<never, BaseRespData<string>>(
    'factory/podJomallOrderCn/printPickPdf',
    { params: { ids } },
  )
}

// 播种墙配货 打单完成
export function submitInspectionApi(
  data: { id: number; version?: number }[],
  warehouseId: number | string,
  boxIndex?: number | null,
) {
  const params = new URLSearchParams()
  // 先放 warehouseId，再放 boxIndex
  params.set('warehouseId', String(warehouseId))
  if (boxIndex !== undefined && boxIndex !== null) {
    params.set('box', String(boxIndex))
  }

  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/podPrintOrderComplete?${params.toString()}`,
    { orderParamList: data },
  )
}
// 超级播种墙配货 打单完成
export function submitSuperInspectionApi(
  data: { id: number; version?: number }[],
  boxIndex: number | null,
) {
  return axios.post<never, BaseRespData<never>>(
    `super/factory/podJomallOrderCn/podPrintOrderComplete?box=${boxIndex}`,
    {
      orderParamList: data,
    },
  )
}

// 播种墙配货 根据箱子删除pod订单拣货箱子详情
export function clearBoxApi(
  factoryNo: number,
  box: number | null,
  warehouseId: number | string,
) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/delPodBoxOrderDetailsByBox',
    {
      params: { factoryNo, box, warehouseId },
    },
  )
}
// 超级播种墙配货 根据箱子删除pod订单拣货箱子详情
export function clearSuperBoxApi(factoryNo: number, box: number | null) {
  return axios.get<never, BaseRespData<never>>(
    'super/factory/podJomallOrderCn/delPodBoxOrderDetailsByBox',
    {
      params: { factoryNo, box },
    },
  )
}
// 播种墙配货 删除pod订单拣货箱子详情
export function clearAllBoxApi() {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/delPodBoxOrderDetails',
  )
}
// 超级播种墙配货 删除pod订单拣货箱子详情
export function clearSuperAllBoxApi() {
  return axios.get<never, BaseRespData<never>>(
    'super/factory/podJomallOrderCn/delPodBoxOrderDetails',
  )
}

export function updateRemarkApi(id: number, content: string) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/addRemark',
    { id, content },
  )
}

export function getLogisticsCalculation(id: number) {
  return axios.get<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/getLogisticsCalculation',
    { params: { id } },
  )
}
export function loadWarehouseListApi() {
  return axios.get<never, BaseRespData<WarehouseListData[]>>(
    'factoryWarehouseInfo/getAll',
  )
}
export function refreshMaterialApi(data: {
  orderIds?: string
  productIds?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductCn/refreshDesignImages ',
    data,
  )
}
// 拦截状态改变
export function interceptUpdateApi(params: {
  orderIds: (string | number)[]
  interceptStatus: number
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/updateInterceptStatus`,
    params,
  )
}
// 驳回
export function rejectToApi(params: {
  orderStatus: string
  productList: ProductList[]
  reasonStr: string
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/rejectTo`,
    params,
  )
}

// 状态推送
export function statusPushApi(params: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/statusPush`,
    params,
  )
}

// 完成发货
export function completeDeliveryApi(params: {
  orderIdList: (string | number)[]
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/completeDelivery`,
    params,
  )
}
export function refreshProductInformationApi(data: {
  orderIds?: string
  productIds?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderProductCn/refreshProductInfo',
    data,
  )
}
// 设计图排版
export function composingDesignImages(
  url: string,
  data: number[],
  type?: string,
  templateWidth?: number,
) {
  return axios.post<never, BaseRespData<never>>(
    `${url}?type=${type}&templateWidth=${templateWidth}`,
    data,
  )
}
// 转至待拣胚
export function updateLogisticsToPickingApi(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/updateLogisticsToPicking`,
    {
      params,
    },
  )
}
// 转至待排单
export function updateLogisticsToArrangeApi(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/updateLogisticsToArrange`,
    {
      params,
    },
  )
}

export function applyForReplenishmentApi(
  data: {
    id: number
    productId: number
    factorySubOrderNumber: string
    replenishmentNum: string
    podJomallOrderCnStatus: string
  }[],
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductCn/applyForReplenishment`,
    data,
  )
}

export function replenishmentSuccessApi(data: number[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductCn/replenishmentComplete`,
    data,
  )
}
//确认生产
export function confirmProductApi(data: IconfirmSubmit) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/confirmProduct`,
    data,
  )
}
export function toOutOfStockApi(ids: number[]) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/pickingToStockOut`,
    ids,
  )
}

// 排单完成
export function arrangeFinishApi(params: {
  productIdList: number[]
  templateWidth?: number
  type?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductCn/arrangeFinish`,
    params,
  )
}

// 获取工艺
export function getListCraftApi() {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderProductCn/listCraft`,
  )
}

// 批量下载 列表
export function batchDownloadApi(
  params: SearchForm,
  currentPage: number,
  pageSize: number,
) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podBatchDownload/cn/list_page`,
    {
      ...params,
      currentPage,
      pageSize,
    },
  )
}

// 批量下载 下载
export function batchDownloadDownloadApi(params: { id: number; type: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/download`,
    {
      params,
    },
  )
}

// 批量下载 删除
export function batchDownloadDeleteApi(params: { ids: string }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/delete`,
    {
      params,
    },
  )
}

// 批量下载 重新排版
export function batchDownloadRecomposingApi(params: {
  id: number
  type?: string
  templateWidth?: number
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/reCnComposingDesignImages`,
    {
      params,
    },
  )
}
export function batchDownloadCnRecomposingApi(params: { id: number }) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podBatchDownload/reCnComposingDesignImages`,
    {
      params,
    },
  )
}
// 生产完成
export function updateToWaitShipmentApi(params: {
  cnUpdateParams: Array<{
    id: number | string
    podJomallOrderCnId: number | string
    factorySubOrderNumber: number | string
    version: number | string
  }>
}) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/updateToWaitShipment`,
    params,
  )
}

//创建物流订单
export function createLogisticsOrdersApi(orderIdList: (string | number)[], logisticsWayId: number | null) {
  return axios.post<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/createLogisticsOrders`,
    { orderIdList, logisticsWayId },
  )
}

// 获取跟踪号
export function getTrackingNumberApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/getTrackingNumber',
    orderIds,
  )
}
// 获取打印面单
export function getfaceSimplexFileApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/getfaceSimplexFile',
    orderIds,
  )
}
// 取消物流订单
export function cancelLogisticsOrderApi(orderIds: (string | number)[]) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/cancelLogisticsOrder',
    orderIds,
  )
}
// 更改物流
export function changeLogisticsApi(params: {
  updateByIdParam: {
    id: string | number
    dataVersion: number
  }
  logisticsTrialCalculation: LogisticsData
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/changeLogistics',
    params,
  )
}
// 修改自有物流信息
export function updateSelfLogistics(params: {
  trackingNumber: string
  expressSheet: string
  processNumber: string
  id?: string
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/updateSelfLogistics',
    params,
  )
}
// 上传物流面单
export function uploadExpressSheet(params: {
  trackingNumber: string
  file: File
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/uploadExpressSheet',
    params,
  )
}
// 打印拣货单item
export function printPickPdfByBatchNumberApi(params: {
  batchArrangeNumber: string
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderProductCn/printPickPdfByBatchNumber`,
    {
      params,
    },
  )
}
// 打印生产单item
export function printProductionPdfByBatchNumberApi(params: {
  batchArrangeNumber: string
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderProductCn/printProductionPdfByBatchNumber`,
    {
      params,
    },
  )
}
// 获取US标签列表
export function getCustomTagListCnApi() {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/getCustomTagList`,
  )
}
// 根据店铺单号或跟踪号查询订单
export function listByNoApi(params: {
  type: string
  no: string
  logisticsCompanyCode?: string
}) {
  return axios.get<never, BaseRespData<never>>(
    `factory/podJomallOrderCn/listByNo`,
    { params },
  )
}
//保存称重分拣
export function orderWeighingApi(params: {
  podCnWeighingParams: { id?: string; outWarehouseWeight?: string }[]
}) {
  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/orderWeighing',
    params,
  )
}
//获取物流公司
export function allErpCodeListApi() {
  return axios.get<never, BaseRespData<never>>(
    '/logisticsCompany/allErpCodeList',
  )
}
export function updateCustomDeclarationInfoApi({
  params,
  ids,
}: {
  params: CustomDeclarationInfoForm
  ids: string
}) {
  const formData = new FormData()
  formData.append('ids', ids)
  Object.keys(params).forEach((key) => {
    const value = params[key as keyof CustomDeclarationInfoForm]
    if (value !== undefined && value !== null) {
      formData.append(key, String(value))
    }
  })

  return axios.post<never, BaseRespData<never>>(
    'factory/podJomallOrderCn/batchUpdateCustomsClearanceInfo',
    formData,
    {
      headers: { 'content-type': 'multipart/form-data' },
    },
  )
}
// 标记缺货/移除缺货共用
export function updateProductOutOfStockApi(params: {
  productIds: (number | string)[]
  orderFrom: string
  outOfStock: boolean
}) {
  return axios.post<never, BaseRespData<never>>(
    `/factory/podJomallOrderProductCnUs/updateProductOutOfStock`,
    params,
  )
}

// 打印普胚生产单
export function printNormalProducePdf(orderIds: number[]) {
  return axios.post<never, BaseRespData<string>>(
    'factory/podJomallOrderProductCn/printNormalProducePdf',
    orderIds,
  )
}
